/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.powersuits.network.MusePacket;
import net.machinemuse.powersuits.network.packets.MusePacketInventoryRefresh;

public class MusePacketInstallModuleRequest
extends MusePacket {
    protected wm stack;
    protected int itemSlot;
    protected String moduleName;

    public MusePacketInstallModuleRequest(Player player, int itemSlot, String moduleName) {
        super(player);
        this.writeInt(itemSlot);
        this.writeString(moduleName);
    }

    public MusePacketInstallModuleRequest(DataInputStream data, Player player) {
        super(data, player);
        this.itemSlot = this.readInt();
        this.moduleName = this.readString(64);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            jc srvplayer = (jc)player;
            this.stack = srvplayer.bK.a(this.itemSlot);
        }
    }

    @Override
    public void handleServer(jc playerEntity) {
        if (this.moduleName != null) {
            so inventory = playerEntity.bK;
            IPowerModule moduleType = ModuleManager.getModule(this.moduleName);
            if (moduleType == null || !moduleType.isAllowed()) {
                playerEntity.a("Server has disallowed this module. Sorry!");
                return;
            }
            List cost = moduleType.getInstallCost();
            if (!MuseItemUtils.itemHasModule(this.stack, this.moduleName) && MuseItemUtils.hasInInventory(cost, playerEntity.bK) || playerEntity.ce.d) {
                MuseItemUtils.itemAddModule(this.stack, moduleType);
                for (wm stackInCost : cost) {
                    ElectricItemUtils.givePlayerEnergy((sq)playerEntity, ElectricItemUtils.jouleValueOfComponent(stackInCost));
                }
                List slotsToUpdate = new ArrayList<Integer>();
                if (!playerEntity.ce.d) {
                    slotsToUpdate = MuseItemUtils.deleteFromInventory(cost, inventory);
                }
                slotsToUpdate.add(this.itemSlot);
                for (Integer slotiter : slotsToUpdate) {
                    MusePacketInventoryRefresh reply = new MusePacketInventoryRefresh(this.player, slotiter, inventory.a(slotiter.intValue()));
                    PacketDispatcher.sendPacketToPlayer((ei)reply.getPacket250(), (Player)this.player);
                }
            }
        }
    }

    @Override
    public void handleClient(bdw player) {
    }
}

