/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MuseLogger;
import net.machinemuse.powersuits.network.MusePacket;
import net.machinemuse.powersuits.network.packets.MusePacketFallDistance;
import net.machinemuse.powersuits.network.packets.MusePacketInstallModuleRequest;
import net.machinemuse.powersuits.network.packets.MusePacketInventoryRefresh;
import net.machinemuse.powersuits.network.packets.MusePacketModeChangeRequest;
import net.machinemuse.powersuits.network.packets.MusePacketPlasmaBolt;
import net.machinemuse.powersuits.network.packets.MusePacketPlayerUpdate;
import net.machinemuse.powersuits.network.packets.MusePacketSalvageModuleRequest;
import net.machinemuse.powersuits.network.packets.MusePacketToggleRequest;
import net.machinemuse.powersuits.network.packets.MusePacketTweakRequest;

public class MusePacketHandler
implements IPacketHandler {
    public static BiMap packetConstructors = HashBiMap.create();

    public MusePacketHandler register() {
        MusePacketHandler.addPacketType(1, MusePacketInventoryRefresh.class);
        MusePacketHandler.addPacketType(2, MusePacketInstallModuleRequest.class);
        MusePacketHandler.addPacketType(3, MusePacketSalvageModuleRequest.class);
        MusePacketHandler.addPacketType(4, MusePacketTweakRequest.class);
        MusePacketHandler.addPacketType(5, MusePacketFallDistance.class);
        MusePacketHandler.addPacketType(6, MusePacketPlayerUpdate.class);
        MusePacketHandler.addPacketType(7, MusePacketToggleRequest.class);
        MusePacketHandler.addPacketType(8, MusePacketPlasmaBolt.class);
        MusePacketHandler.addPacketType(9, MusePacketModeChangeRequest.class);
        NetworkRegistry.instance().registerChannel((IPacketHandler)this, Config.getNetworkChannelName());
        return this;
    }

    public void onPacketData(cg manager, dk payload, Player player) {
        MusePacket repackaged;
        if (payload.a.equals(Config.getNetworkChannelName()) && (repackaged = MusePacketHandler.repackage(payload, player)) != null) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (side == Side.CLIENT) {
                repackaged.handleClient((bdw)player);
            } else if (side == Side.SERVER) {
                repackaged.handleServer((jc)player);
            }
        }
    }

    public static MusePacket repackage(dk payload, Player player) {
        MusePacket repackaged = null;
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(payload.c));
        sq target = (sq)player;
        try {
            int packetType = data.readInt();
            repackaged = MusePacketHandler.useConstructor((Constructor)packetConstructors.get((Object)packetType), data, player);
        }
        catch (IOException e) {
            MuseLogger.logError("PROBLEM READING PACKET TYPE D:");
            e.printStackTrace();
            return null;
        }
        return repackaged;
    }

    public static int getTypeID(MusePacket packet) {
        try {
            return (Integer)packetConstructors.inverse().get((Object)MusePacketHandler.getConstructor(packet.getClass()));
        }
        catch (NoSuchMethodException e) {
            MuseLogger.logError("INVALID PACKET CONSTRUCTOR D:");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            MuseLogger.logError("PACKET SECURITY PROBLEM D:");
            e.printStackTrace();
        }
        return -150;
    }

    protected static Constructor getConstructor(Class packetType) throws NoSuchMethodException, SecurityException {
        return packetType.getConstructor(DataInputStream.class, Player.class);
    }

    protected static MusePacket useConstructor(Constructor constructor, DataInputStream data, Player player) {
        try {
            return (MusePacket)constructor.newInstance(data, player);
        }
        catch (InstantiationException e) {
            MuseLogger.logError("PROBLEM INSTATIATING PACKET D:");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            MuseLogger.logError("PROBLEM ACCESSING PACKET D:");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            MuseLogger.logError("INVALID PACKET CONSTRUCTOR D:");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            MuseLogger.logError("PROBLEM INVOKING PACKET CONSTRUCTOR D:");
            e.printStackTrace();
        }
        return null;
    }

    public static boolean addPacketType(int id, Class packetType) {
        try {
            packetConstructors.put((Object)id, (Object)MusePacketHandler.getConstructor(packetType));
            return true;
        }
        catch (NoSuchMethodException e) {
            MuseLogger.logError("UNABLE TO REGISTER PACKET TYPE: " + packetType + ": INVALID CONSTRUCTOR");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            MuseLogger.logError("UNABLE TO REGISTER PACKET TYPE: " + packetType + ": SECURITY PROBLEM");
            e.printStackTrace();
        }
        return false;
    }
}

