/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseCommonStrings;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemElectricArmor;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.minecraftforge.common.IArmorTextureProvider;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemPowerArmor
extends ItemElectricArmor
implements ISpecialArmor,
IModularItem,
IArmorTextureProvider {
    public ItemPowerArmor(int id, int renderIndex, int armorType) {
        super(id, uq.a, renderIndex, armorType);
        this.d(1);
        this.a(Config.getCreativeTab());
    }

    public String getArmorTextureFile(wm itemstack) {
        if (itemstack != null) {
            bs itemTag = MuseItemUtils.getMuseItemTag(itemstack);
            if (itemTag.b("didColour")) {
                itemTag.o("didColour");
                return "/mods/mmmPowersuits/textures/models/blankarmor.png";
            }
            if (MuseItemUtils.itemHasActiveModule(itemstack, "Transparent Armor")) {
                return "/mods/mmmPowersuits/textures/models/blankarmor.png";
            }
            if (itemstack.b() instanceof ItemPowerArmorLeggings) {
                if (MuseItemUtils.itemHasModule(itemstack, "Citizen Joe Style")) {
                    return "/mods/mmmPowersuits/textures/models/joearmorpants.png";
                }
                return "/mods/mmmPowersuits/textures/models/sebkarmorpants.png";
            }
            if (MuseItemUtils.itemHasModule(itemstack, "Citizen Joe Style")) {
                return "/mods/mmmPowersuits/textures/models/joearmor.png";
            }
            return "/mods/mmmPowersuits/textures/models/sebkarmor.png";
        }
        return "/mods/mmmPowersuits/textures/models/blankarmor.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(ng player, wm armor, mg source, double damage, int slot) {
        int priority = 1;
        double armorDouble = player instanceof sq ? this.getArmorDouble((sq)player, armor) : 2.0;
        double absorbRatio = 0.04 * armorDouble;
        int absorbMax = (int)armorDouble * 75;
        return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
    }

    public static double clampDouble(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public int c() {
        return 0;
    }

    public Colour getColorFromItemStack(wm stack) {
        double computedred = ModuleManager.computeModularProperty(stack, "Red Tint");
        double computedgreen = ModuleManager.computeModularProperty(stack, "Green Tint");
        double computedblue = ModuleManager.computeModularProperty(stack, "Blue Tint");
        Colour colour = new Colour(ItemPowerArmor.clampDouble(1.0 + computedred - (computedblue + computedgreen), 0.0, 1.0), ItemPowerArmor.clampDouble(1.0 + computedgreen - (computedblue + computedred), 0.0, 1.0), ItemPowerArmor.clampDouble(1.0 + computedblue - (computedred + computedgreen), 0.0, 1.0), 1.0);
        return colour;
    }

    @SideOnly(value=Side.CLIENT)
    public int a(wm stack, int par2) {
        Colour c = this.getColorFromItemStack(stack);
        return c.getInt();
    }

    public int b(wm stack) {
        bs itemTag = MuseItemUtils.getMuseItemTag(stack);
        itemTag.a("didColour", "yes");
        Colour c = this.getColorFromItemStack(stack);
        return c.getInt();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean b() {
        return false;
    }

    public boolean a(wm stack) {
        bs itemTag = MuseItemUtils.getMuseItemTag(stack);
        return MuseItemUtils.tagHasModule(itemTag, "Red Tint") || MuseItemUtils.tagHasModule(itemTag, "Green Tint") || MuseItemUtils.tagHasModule(itemTag, "Blue Tint");
    }

    public int getArmorDisplay(sq player, wm armor, int slot) {
        return (int)this.getArmorDouble(player, armor);
    }

    public double getArmorDouble(sq player, wm stack) {
        double totalArmor = 0.0;
        bs props = MuseItemUtils.getMuseItemTag(stack);
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        double physArmor = ModuleManager.computeModularProperty(stack, "Armor (Physical)");
        double enerArmor = ModuleManager.computeModularProperty(stack, "Armor (Energy)");
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        totalArmor += physArmor;
        if (energy > enerConsum) {
            totalArmor += enerArmor;
        }
        totalArmor = Math.min(Config.getMaximumArmorPerPiece(), totalArmor);
        return totalArmor;
    }

    public void damageArmor(ng entity, wm stack, mg source, int damage, int slot) {
        bs itemProperties = MuseItemUtils.getMuseItemTag(stack);
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        double drain = enerConsum * (double)damage;
        if (entity instanceof sq) {
            ElectricItemUtils.drainPlayerEnergy((sq)entity, drain);
        } else {
            this.drainEnergyFrom(stack, drain);
        }
    }

    public void a(wm stack, sq player, List currentTipList, boolean advancedToolTips) {
        MuseCommonStrings.addInformation(stack, player, currentTipList, advancedToolTips);
    }

    public static String formatInfo(String string, double value) {
        return string + "\t" + MuseStringUtils.formatNumberShort(value);
    }

    @Override
    public List getLongInfo(sq player, wm stack) {
        ArrayList<String> info = new ArrayList<String>();
        bs itemProperties = MuseItemUtils.getMuseItemTag(stack);
        info.add("Detailed Summary");
        info.add(ItemPowerArmor.formatInfo("Armor", this.getArmorDouble(player, stack)));
        info.add(ItemPowerArmor.formatInfo("Energy Storage", this.getMaxJoules(stack)) + "J");
        info.add(ItemPowerArmor.formatInfo("Weight", MuseCommonStrings.getTotalWeight(stack)) + "g");
        return info;
    }
}

