/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.UEElectricAdapter;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class ItemElectricTool
extends vr
implements IItemElectric {
    protected ItemElectricTool(int par1, int par2, wl par3EnumToolMaterial, apa[] par4ArrayOfBlock) {
        super(par1, par2, par3EnumToolMaterial, par4ArrayOfBlock);
    }

    public double getCurrentEnergy(wm stack) {
        return MuseItemUtils.getDoubleOrZero(stack, "Current Energy");
    }

    public double getMaxEnergy(wm stack) {
        return ModuleManager.computeModularProperty(stack, "Maximum Energy");
    }

    public void setCurrentEnergy(wm stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, "Current Energy", energy);
    }

    public double drainEnergyFrom(wm stack, double requested) {
        double available = this.getCurrentEnergy(stack);
        if (available > requested) {
            this.setCurrentEnergy(stack, available - requested);
            return requested;
        }
        this.setCurrentEnergy(stack, 0.0);
        return available;
    }

    public double giveEnergyTo(wm stack, double provided) {
        double max;
        double available = this.getCurrentEnergy(stack);
        if (available + provided < (max = this.getMaxEnergy(stack))) {
            this.setCurrentEnergy(stack, available + provided);
            return provided;
        }
        this.setCurrentEnergy(stack, max);
        return max - available;
    }

    @Override
    public double getJoules(wm itemStack) {
        return UEElectricAdapter.museEnergyToJoules(this.getCurrentEnergy(itemStack));
    }

    @Override
    public void setJoules(double joules, wm itemStack) {
        this.setCurrentEnergy(itemStack, UEElectricAdapter.museEnergyFromJoules(joules));
    }

    @Override
    public double getMaxJoules(wm itemStack) {
        return UEElectricAdapter.museEnergyToJoules(this.getMaxEnergy(itemStack));
    }

    @Override
    public double getVoltage(wm itemStack) {
        return 120.0;
    }

    @Override
    public ElectricityPack onReceive(ElectricityPack electricityPack, wm itemStack) {
        double energyReceiving = UEElectricAdapter.museEnergyFromElectricityPack(electricityPack);
        double energyConsumed = this.giveEnergyTo(itemStack, energyReceiving);
        ElectricityPack packConsumed = UEElectricAdapter.museEnergyToElectricityPack(energyConsumed, this.getVoltage(itemStack));
        return packConsumed;
    }

    @Override
    public ElectricityPack onProvide(ElectricityPack electricityPack, wm itemStack) {
        double energyRequested = UEElectricAdapter.museEnergyFromElectricityPack(electricityPack);
        double energyGiven = this.drainEnergyFrom(itemStack, energyRequested);
        ElectricityPack packGiven = UEElectricAdapter.museEnergyToElectricityPack(energyGiven, this.getVoltage(itemStack));
        return packGiven;
    }

    @Override
    public ElectricityPack getReceiveRequest(wm itemStack) {
        return UEElectricAdapter.museEnergyToElectricityPack(this.getMaxEnergy(itemStack) - this.getCurrentEnergy(itemStack), this.getVoltage(itemStack));
    }

    @Override
    public ElectricityPack getProvideRequest(wm itemStack) {
        return UEElectricAdapter.museEnergyToElectricityPack(this.getMaxEnergy(itemStack) - this.getCurrentEnergy(itemStack), this.getVoltage(itemStack));
    }
}

