/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.util.HashMap;
import java.util.Map;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class MovementManager {
    public static Map playerJumpMultipliers = new HashMap();
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public static double getPlayerJumpMultiplier(sq player) {
        if (playerJumpMultipliers.containsKey(player.bS)) {
            return (Double)playerJumpMultipliers.get(player.bS);
        }
        return 0.0;
    }

    public static void setPlayerJumpTicks(sq player, double number) {
        playerJumpMultipliers.put(player.bS, number);
    }

    @ForgeSubscribe
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        sq player;
        wm stack;
        if (event.entityLiving instanceof sq && (stack = (player = (sq)event.entityLiving).q(1)) != null && stack.b() instanceof ItemPowerArmor && MuseItemUtils.itemHasActiveModule(stack, "Jump Assist")) {
            double avail;
            double jumpAssist = ModuleManager.computeModularProperty(stack, "Jump Boost") * 2.0;
            double drain = ModuleManager.computeModularProperty(stack, "Jump Energy Consumption");
            if (drain < (avail = ElectricItemUtils.getPlayerEnergy(player))) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                MovementManager.setPlayerJumpTicks(player, jumpAssist);
                double jumpCompensationRatio = ModuleManager.computeModularProperty(stack, "Jump Exhaustion Compensation");
                if (player.ah()) {
                    player.cl().a((float)(-0.8 * jumpCompensationRatio));
                } else {
                    player.cl().a((float)(-0.2 * jumpCompensationRatio));
                }
            }
        }
    }

    @ForgeSubscribe
    public void handleFallEvent(LivingFallEvent event) {
        double avail;
        double distanceAbsorb;
        double drain;
        sq player;
        wm boots;
        if (event.entityLiving instanceof sq && (boots = (player = (sq)event.entityLiving).q(0)) != null && MuseItemUtils.itemHasActiveModule(boots, "Shock Absorber") && event.distance > 3.0f && (drain = (distanceAbsorb = (double)event.distance * ModuleManager.computeModularProperty(boots, "Distance Reduction")) * ModuleManager.computeModularProperty(boots, "Impact Energy consumption")) < (avail = ElectricItemUtils.getPlayerEnergy(player))) {
            ElectricItemUtils.drainPlayerEnergy(player, drain);
            event.distance = (float)((double)event.distance - distanceAbsorb);
        }
    }

    public static double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        double distance = 0.03920000076293945 * ticks * ticks;
        return distance;
    }
}

