/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PlayerInputMap {
    protected static Map playerInputs = new HashMap();
    public float forwardKey;
    public float strafeKey;
    public boolean jumpKey;
    public boolean sneakKey;
    public boolean downKey;
    public double motionX;
    public double motionY;
    public double motionZ;

    public static PlayerInputMap getInputMapFor(String playerName) {
        PlayerInputMap map = (PlayerInputMap)playerInputs.get(playerName);
        if (map == null) {
            map = new PlayerInputMap(playerName);
        }
        return map;
    }

    public PlayerInputMap(String playerName) {
        playerInputs.put(playerName, this);
    }

    public boolean writeToStream(DataOutputStream stream) {
        try {
            stream.writeFloat(this.forwardKey);
            stream.writeFloat(this.strafeKey);
            stream.writeBoolean(this.jumpKey);
            stream.writeBoolean(this.sneakKey);
            stream.writeBoolean(this.downKey);
            stream.writeDouble(this.motionX);
            stream.writeDouble(this.motionY);
            stream.writeDouble(this.motionZ);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean readFromStream(DataInputStream stream) {
        try {
            this.forwardKey = stream.readFloat();
            this.strafeKey = stream.readFloat();
            this.jumpKey = stream.readBoolean();
            this.sneakKey = stream.readBoolean();
            this.downKey = stream.readBoolean();
            this.motionX = stream.readDouble();
            this.motionY = stream.readDouble();
            this.motionZ = stream.readDouble();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

