/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.ToggleablePowerModule;
import net.machinemuse.powersuits.powermodule.tool.MultimeterModule;

public class ModCompatability {
    private static Class Ic2Items;

    public static boolean isGregTechLoaded() {
        return Loader.isModLoaded((String)"GregTech_Addon");
    }

    public static boolean isBasicComponentsLoaded() {
        return Loader.isModLoaded((String)"BasicComponents");
    }

    public static boolean isIndustrialCraftLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isThaumCraftLoaded() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isAndrewAddonsLoaded() {
        return Loader.isModLoaded((String)"AndrewPowersuitAddons");
    }

    public static boolean enableThaumGogglesModule() {
        boolean defaultval = ModCompatability.isThaumCraftLoaded();
        return Config.getConfig().get("Special Modules", "Thaumcraft Goggles Module", defaultval).getBoolean(defaultval);
    }

    public static boolean vanillaRecipesEnabled() {
        boolean defaultval = !ModCompatability.isBasicComponentsLoaded() && !ModCompatability.isIndustrialCraftLoaded();
        return Config.getConfig().get("general", "Vanilla Recipes", defaultval).getBoolean(defaultval);
    }

    private static boolean isAtomicScienceLoaded() {
        return Loader.isModLoaded((String)"AtomicScience");
    }

    public static boolean UERecipesEnabled() {
        boolean defaultval = ModCompatability.isBasicComponentsLoaded();
        return Config.getConfig().get("general", "Universal Electricity Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean IC2RecipesEnabled() {
        boolean defaultval = ModCompatability.isIndustrialCraftLoaded() && !ModCompatability.isGregTechLoaded();
        return Config.getConfig().get("general", "IndustrialCraft Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean GregTechRecipesEnabled() {
        boolean defaultval = ModCompatability.isGregTechLoaded();
        return Config.getConfig().get("general", "Gregtech Recipes", defaultval).getBoolean(defaultval);
    }

    public static boolean ThermalExpansionRecipesEnabled() {
        boolean defaultval = ModCompatability.isThermalExpansionLoaded();
        return Config.getConfig().get("general", "Thermal Expansion Recipes", defaultval).getBoolean(defaultval);
    }

    public static int joulesToEU(double joules) {
        return (int)(joules / ModCompatability.getIC2Ratio());
    }

    public static double joulesFromEU(int eu2) {
        return ModCompatability.getIC2Ratio() * (double)eu2;
    }

    public static double getUERatio() {
        return Config.getConfig().get("general", "Energy per UEJ", 1.0).getDouble(1.0);
    }

    public static double getIC2Ratio() {
        return Config.getConfig().get("general", "Energy per IC2 EU", 0.4).getDouble(0.4);
    }

    public static double getBCRatio() {
        return Config.getConfig().get("general", "Energy per MJ", 1.0).getDouble(1.0);
    }

    public static wm getIC2Item(String name) {
        try {
            Object ret;
            if (Ic2Items == null) {
                Ic2Items = Class.forName("ic2.core.Ic2Items");
            }
            if ((ret = Ic2Items.getField(name).get(null)) instanceof wm) {
                return ((wm)ret).m();
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("IC2 API: Call getItem failed for " + name);
            return null;
        }
    }

    public static wm getGregtechItem(int aIndex, int aAmount, int aMeta) {
        try {
            return (wm)Class.forName("gregtechmod.GT_Mod").getMethod("getGregTechItem", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void registerModSpecificModules() {
        ModCompatability.getBCRatio();
        ModCompatability.getIC2Ratio();
        if (ModCompatability.isThaumCraftLoaded() && ModCompatability.enableThaumGogglesModule()) {
            wm gogglesStack = null;
            try {
                Class<?> tcItems = Class.forName("thaumcraft.common.Config");
                Field itemGoggles = tcItems.getField("itemGoggles");
                wk goggles = (wk)itemGoggles.get(itemGoggles);
                gogglesStack = new wm(goggles);
                PowerModuleBase module = new PowerModule("Aurameter", Arrays.asList(ModularPowersuits.powerArmorHead), "bluestar", "Special").setDescription("Connect up some Thaumic goggles to show the nearby aura values. (Does not reveal aura nodes, only shows the HUD)").addInstallCost(ItemComponent.laserHologram.m()).addInstallCost(gogglesStack);
                ModuleManager.addModule(module);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PowerModuleBase module = new MultimeterModule(Arrays.asList(ModularPowersuits.powerTool));
        if (ModCompatability.isAtomicScienceLoaded()) {
            module = new ToggleablePowerModule("Radiation Shielding", Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet), "greenstar", "Armor").setDescription("Protect yourself from that pesky radiation poisoning. *Must be on every piece*").addInstallCost(Config.copyAndResize(ItemComponent.basicPlating, 3)).addBaseProperty("Weight", 0.5);
            ModuleManager.addModule(module);
        }
    }

    public static wm getThermexItem(String string, int quantity) {
        return null;
    }
}

