/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.common.MuseCreativeTab;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.item.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.ItemPowerGauntlet;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.ToggleablePowerModule;
import net.machinemuse.powersuits.powermodule.misc.InvisibilityModule;
import net.machinemuse.powersuits.powermodule.misc.NightVisionModule;
import net.machinemuse.powersuits.powermodule.misc.WaterElectrolyzerModule;
import net.machinemuse.powersuits.powermodule.movement.BlinkDriveModule;
import net.machinemuse.powersuits.powermodule.movement.ClimbAssistModule;
import net.machinemuse.powersuits.powermodule.movement.FlightControlModule;
import net.machinemuse.powersuits.powermodule.movement.GliderModule;
import net.machinemuse.powersuits.powermodule.movement.JetBootsModule;
import net.machinemuse.powersuits.powermodule.movement.JetPackModule;
import net.machinemuse.powersuits.powermodule.movement.JumpAssistModule;
import net.machinemuse.powersuits.powermodule.movement.ParachuteModule;
import net.machinemuse.powersuits.powermodule.movement.ShockAbsorberModule;
import net.machinemuse.powersuits.powermodule.movement.SprintAssistModule;
import net.machinemuse.powersuits.powermodule.movement.SwimAssistModule;
import net.machinemuse.powersuits.powermodule.tool.AquaAffinityModule;
import net.machinemuse.powersuits.powermodule.tool.AxeModule;
import net.machinemuse.powersuits.powermodule.tool.DiamondPickUpgradeModule;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.powersuits.powermodule.tool.ShearsModule;
import net.machinemuse.powersuits.powermodule.tool.ShovelModule;
import net.machinemuse.powersuits.powermodule.weapon.PlasmaCannonModule;
import net.machinemuse.powersuits.powermodule.weapon.RailgunModule;
import net.minecraftforge.common.Configuration;
import org.lwjgl.input.Keyboard;

public class Config {
    public static final String RESOURCE_PREFIX = "/mods/mmmPowersuits/";
    public static final String TEXTURE_PREFIX = "/mods/mmmPowersuits/textures/";
    public static final String SOUND_PREFIX = "/mods/mmmPowersuits/sound/";
    public static final String SEBK_ARMOR_PATH = "/mods/mmmPowersuits/textures/models/sebkarmor.png";
    public static final String SEBK_ARMORPANTS_PATH = "/mods/mmmPowersuits/textures/models/sebkarmorpants.png";
    public static final String TINKERTABLE_TEXTURE_PATH = "/mods/mmmPowersuits/textures/models/tinkertable_tx.png";
    public static final String BLANK_ARMOR_MODEL_PATH = "/mods/mmmPowersuits/textures/models/blankarmor.png";
    public static final String SEBK_TOOL_TEXTURE = "/mods/mmmPowersuits/textures/models/tool.png";
    public static final String CITIZENJOE_ARMOR_PATH = "/mods/mmmPowersuits/textures/models/joearmor.png";
    public static final String CITIZENJOE_ARMORPANTS_PATH = "/mods/mmmPowersuits/textures/models/joearmorpants.png";
    private static Configuration config;

    public static void init(Configuration config) {
        Config.config = config;
        config.load();
        BlockTinkerTable.assignedBlockID = config.getBlock("Power Armor Tinker Table", 2477).getInt();
        ItemComponent.assignedItemID = config.getItem("Power Armor Component", 24770).getInt();
        ItemPowerArmorHelmet.assignedItemID = config.getItem("Power Armor Head", 24771).getInt();
        ItemPowerArmorChestplate.assignedItemID = config.getItem("Power Armor Torso", 24772).getInt();
        ItemPowerArmorLeggings.assignedItemID = config.getItem("Power Armor Legs", 24773).getInt();
        ItemPowerArmorBoots.assignedItemID = config.getItem("Power Armor Feet", 24774).getInt();
        ItemPowerGauntlet.assignedItemID = config.getItem("Power Tool", 24775).getInt();
        config.save();
    }

    public static String getNetworkChannelName() {
        return "mmmPowerSuits";
    }

    public static ve getCreativeTab() {
        return MuseCreativeTab.instance();
    }

    public static double getSalvageChance() {
        return config.get("general", "Salvage Ratio", 0.9).getDouble(0.9);
    }

    public static double getMaximumArmorPerPiece() {
        return Math.min(6.0, Math.max(0.0, config.get("general", "Maximum Armor per Piece", 6.0).getDouble(6.0)));
    }

    public static boolean isDebugging() {
        return config.get("general", "Debugging info", false).getBoolean(false);
    }

    public static wm copyAndResize(wm stack, int number) {
        wm copy = stack.m();
        copy.a = number;
        return copy;
    }

    public static void addModule(IPowerModule module) {
        ModuleManager.addModule(module);
    }

    public static void loadPowerModules() {
        List<IModularItem> ARMORONLY = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet);
        List<IModularItem> ALLITEMS = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet, ModularPowersuits.powerTool);
        List<IModularItem> HEADONLY = Arrays.asList(ModularPowersuits.powerArmorHead);
        List<IModularItem> TORSOONLY = Arrays.asList(ModularPowersuits.powerArmorTorso);
        List<IModularItem> LEGSONLY = Arrays.asList(ModularPowersuits.powerArmorLegs);
        List<IModularItem> FEETONLY = Arrays.asList(ModularPowersuits.powerArmorFeet);
        List<IModularItem> TOOLONLY = Arrays.asList(ModularPowersuits.powerTool);
        PowerModuleBase module = new PowerModule("Iron Plating", ARMORONLY, "basicplating2", "Armor").setDescription("Basic plating is heavy but protective.").addInstallCost(Config.copyAndResize(ItemComponent.basicPlating, 1)).addTradeoffProperty("Plating Thickness", "Armor (Physical)", 5.0, " Points").addTradeoffProperty("Plating Thickness", "Weight", 10000.0, "g");
        Config.addModule(module);
        module = new PowerModule("Diamond Plating", ARMORONLY, "advancedplating2", "Armor").setDescription("Advanced plating is lighter, harder, and more protective than Basic but much harder to make.").addInstallCost(Config.copyAndResize(ItemComponent.advancedPlating, 1)).addTradeoffProperty("Plating Thickness", "Armor (Physical)", 6.0, " Points").addTradeoffProperty("Plating Thickness", "Weight", 6000.0, "g");
        Config.addModule(module);
        module = new PowerModule("Energy Shield", ARMORONLY, "energyshield", "Armor").setDescription("Energy shields are much lighter than plating, but consume energy.").addInstallCost(Config.copyAndResize(ItemComponent.fieldEmitter, 2)).addTradeoffProperty("Field Strength", "Armor (Energy)", 6.0, " Points").addTradeoffProperty("Field Strength", "Energy Per Damage", 500.0, "J");
        Config.addModule(module);
        Config.addModule(new AxeModule(TOOLONLY));
        Config.addModule(new PickaxeModule(TOOLONLY));
        Config.addModule(new ShovelModule(TOOLONLY));
        Config.addModule(new ShearsModule(TOOLONLY));
        module = new ToggleablePowerModule("Melee Assist", TOOLONLY, "toolfist", "Weapon").setDescription("A much simpler addon, makes your powertool punches hit harder.").addBaseProperty("Punch Energy Consumption", 10.0, "J").addBaseProperty("Melee Damage", 2.0, "pt").addTradeoffProperty("Impact", "Punch Energy Consumption", 100.0, "J").addTradeoffProperty("Impact", "Melee Damage", 8.0, "pt").addTradeoffProperty("Carry-through", "Punch Energy Consumption", 20.0, "J").addTradeoffProperty("Carry-through", "Melee Knockback", 1.0, "P").addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 2)).addInstallCost(Config.copyAndResize(ItemComponent.lvcapacitor, 1));
        Config.addModule(module);
        Config.addModule(new PlasmaCannonModule(TOOLONLY));
        Config.addModule(new RailgunModule(TOOLONLY));
        module = new PowerModule("Basic Battery", ALLITEMS, "lvbattery", "Energy").setDescription("Integrate a battery to allow the item to store energy.").addInstallCost(Config.copyAndResize(ItemComponent.lvcapacitor, 1)).addBaseProperty("Maximum Energy", 20000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 80000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        module = new PowerModule("Advanced Battery", ALLITEMS, "mvbattery", "Energy").setDescription("Integrate a more advanced battery to store more energy.").addInstallCost(Config.copyAndResize(ItemComponent.mvcapacitor, 1)).addBaseProperty("Maximum Energy", 100000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 400000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        module = new PowerModule("Elite Battery", ALLITEMS, "crystalcapacitor", "Energy").setDescription("Integrate a the most advanced battery to store an extensive amount of energy.").addInstallCost(Config.copyAndResize(ItemComponent.hvcapacitor, 1)).addBaseProperty("Maximum Energy", 750000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 4250000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        Config.addModule(new ParachuteModule(TORSOONLY));
        Config.addModule(new GliderModule(TORSOONLY));
        Config.addModule(new JetPackModule(TORSOONLY));
        Config.addModule(new SprintAssistModule(LEGSONLY));
        Config.addModule(new JumpAssistModule(LEGSONLY));
        Config.addModule(new SwimAssistModule(LEGSONLY));
        Config.addModule(new ClimbAssistModule(LEGSONLY));
        Config.addModule(new JetBootsModule(FEETONLY));
        Config.addModule(new ShockAbsorberModule(FEETONLY));
        Config.addModule(new WaterElectrolyzerModule(HEADONLY));
        Config.addModule(new NightVisionModule(HEADONLY));
        Config.addModule(new FlightControlModule(HEADONLY));
        Config.addModule(new InvisibilityModule(TORSOONLY));
        Config.addModule(new BlinkDriveModule(TOOLONLY));
        Config.addModule(new DiamondPickUpgradeModule(TOOLONLY));
        Config.addModule(new AquaAffinityModule(TOOLONLY));
        module = new ToggleablePowerModule("Custom Colour Module", ALLITEMS, "netherstar", "Cosmetic").setDescription("Give your armor some coloured tinting to customize your armor's appearance.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 1)).addTradeoffProperty("Red Intensity", "Red Tint", 1.0, "%").addTradeoffProperty("Green Intensity", "Green Tint", 1.0, "%").addTradeoffProperty("Blue Intensity", "Blue Tint", 1.0, "%");
        Config.addModule(module);
        module = new ToggleablePowerModule("Transparent Armor", ARMORONLY, "transparentarmor", "Cosmetic").setDescription("Make the item transparent, so you can show off your skin without losing armor.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 1));
        Config.addModule(module);
        module = new PowerModule("Citizen Joe Style", ARMORONLY, "greendrone", "Cosmetic").setDescription("An alternative armor texture, c/o CitizenJoe of IC2 forums.");
        Config.addModule(module);
        Config.getMaximumArmorPerPiece();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static boolean doAdditionalInfo() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Keyboard.isKeyDown((int)42);
    }

    public static Object additionalInfoInstructions() {
        String message = "Press SHIFT for more information.";
        message = MuseStringUtils.wrapMultipleFormatTags(message, new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
        return message;
    }

    public static enum Guis {
        GuiTinkerTable,
        GuiSuitManager,
        GuiPortableCrafting;

    }
}

