/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.machinemuse.powersuits.block.TileEntityTinkerTable;
import net.machinemuse.powersuits.client.KeybindKeyHandler;
import net.machinemuse.powersuits.client.KeybindManager;
import net.machinemuse.powersuits.client.render.RenderPlasmaBolt;
import net.machinemuse.powersuits.client.render.TinkerTableRenderer;
import net.machinemuse.powersuits.client.render.ToolRenderer;
import net.machinemuse.powersuits.common.CommonProxy;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.event.SoundEventHandler;
import net.machinemuse.powersuits.event.TextureStitchHandler;
import net.machinemuse.powersuits.event.ThaumRenderEventHandler;
import net.machinemuse.powersuits.network.MusePacketHandler;
import net.machinemuse.powersuits.tick.ClientTickHandler;
import net.machinemuse.powersuits.tick.PlayerTickHandler;
import net.machinemuse.powersuits.tick.RenderTickHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static ToolRenderer toolRenderer = new ToolRenderer();
    private static ClientTickHandler clientTickHandler;
    private static RenderTickHandler renderTickHandler;
    private static PlayerTickHandler playerTickHandler;
    public static KeybindKeyHandler keybindHandler;

    @Override
    public void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((int)ModularPowersuits.powerTool.cp, (IItemRenderer)toolRenderer);
        int tinkTableRenderID = RenderingRegistry.getNextAvailableRenderId();
        TinkerTableRenderer tinkTableRenderer = new TinkerTableRenderer(tinkTableRenderID);
        ModularPowersuits.tinkerTable.setRenderType(tinkTableRenderID);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTinkerTable.class, (bjf)tinkTableRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)tinkTableRenderer);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaBolt.class, (bha)new RenderPlasmaBolt());
        MinecraftForge.EVENT_BUS.register((Object)new TextureStitchHandler());
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/tinkertable_tx.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/blankarmor.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/sebkarmor.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/sebkarmorpants.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/joearmor.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/joearmorpants.png");
        MinecraftForgeClient.preloadTexture((String)"/mods/mmmPowersuits/textures/models/tool.png");
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        keybindHandler = new KeybindKeyHandler();
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)keybindHandler);
        KeybindManager.readInKeybinds();
        playerTickHandler = new PlayerTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)playerTickHandler, (Side)Side.CLIENT);
        renderTickHandler = new RenderTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)renderTickHandler, (Side)Side.CLIENT);
        clientTickHandler = new ClientTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)clientTickHandler, (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new SoundEventHandler());
        if (ModCompatability.isThaumCraftLoaded() && ModCompatability.enableThaumGogglesModule()) {
            MinecraftForge.EVENT_BUS.register((Object)new ThaumRenderEventHandler());
        }
        packetHandler = new MusePacketHandler().register();
    }

    @Override
    public void postInit() {
    }
}

