/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.MuseRect;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ModuleSelectionSubFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ItemSelectionFrame target;
    protected Map categories;
    protected List moduleButtons;
    protected int selectedModule = -1;
    protected IPowerModule prevSelection;

    public ModuleSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super(topleft, bottomright, borderColour, insideColour);
        this.target = target;
        this.moduleButtons = new ArrayList();
        this.categories = new HashMap();
    }

    @Override
    public void update(double mousex, double mousey) {
    }

    @Override
    public void draw() {
        if (this.target.getSelectedItem() != null) {
            this.loadModules();
            this.drawBackground();
            this.drawItems();
            this.drawSelection();
        }
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.draw();
        }
    }

    private void drawSelection() {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MuseRenderer.drawCircleAround(((ClickableModule)this.moduleButtons.get(this.selectedModule)).getPosition().x(), ((ClickableModule)this.moduleButtons.get(this.selectedModule)).getPosition().y(), 10.0);
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.moduleButtons.size() > this.selectedModule && this.selectedModule != -1) {
            return (ClickableModule)this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void loadModules() {
        ClickableItem selectedItem = this.target.getSelectedItem();
        if (selectedItem != null) {
            double centerx = (this.border.left() + this.border.right()) / 2.0;
            double centery = (this.border.top() + this.border.bottom()) / 2.0;
            this.moduleButtons = new ArrayList();
            this.categories = new HashMap();
            List workingModules = MuseItemUtils.getValidModulesForItem(null, selectedItem.getItem());
            if (workingModules.size() > 0) {
                List points = MuseRenderer.pointsInLine(workingModules.size(), new MusePoint2D(centerx, this.border.top()), new MusePoint2D(centerx, this.border.bottom()));
                this.selectedModule = -1;
                Iterator pointiter = points.iterator();
                for (IPowerModule module : workingModules) {
                    ModuleSelectionSubFrame frame = this.getOrCreateCategory(module.getCategory());
                    ClickableModule moduleClickable = frame.addModule(module);
                    if (moduleClickable.getModule().equals(this.prevSelection)) {
                        this.selectedModule = this.moduleButtons.size();
                    }
                    this.moduleButtons.add(moduleClickable);
                }
            }
        }
    }

    private ModuleSelectionSubFrame getOrCreateCategory(String category) {
        if (this.categories.containsKey(category)) {
            return (ModuleSelectionSubFrame)this.categories.get(category);
        }
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, new MuseRect(this.border.left() + 4.0, this.border.top() + 4.0 + (double)(30 * this.categories.size()), this.border.right() - 4.0, this.border.bottom() + 34.0 + (double)(30 * this.categories.size())));
        this.categories.put(category, frame);
        return frame;
    }

    @Override
    public void onMouseDown(double x2, double y, int button) {
        this.loadModules();
        int i2 = 0;
        for (ClickableModule module : this.moduleButtons) {
            if (module.hitBox(x2, y)) {
                this.selectedModule = i2;
                this.prevSelection = module.getModule();
                break;
            }
            ++i2;
        }
    }

    @Override
    public List getToolTip(int x2, int y) {
        if (this.moduleButtons != null) {
            int moduleHover = -1;
            int i2 = 0;
            for (ClickableModule module : this.moduleButtons) {
                if (module.hitBox(x2, y)) {
                    moduleHover = i2;
                    break;
                }
                ++i2;
            }
            if (moduleHover > -1) {
                return ((ClickableModule)this.moduleButtons.get(moduleHover)).getToolTip();
            }
            return null;
        }
        return null;
    }
}

