/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.FlyFromPointToPoint2D;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.ScrollableFrame;

public class ItemSelectionFrame
extends ScrollableFrame {
    protected List itemButtons;
    protected int selectedItemStack = -1;
    protected sq player;
    protected List itemPoints;

    public ItemSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, sq player) {
        super(topleft, bottomright, borderColour, insideColour);
        this.player = player;
        List slots = MuseItemUtils.getModularItemSlotsInInventory((lt)player.bK);
        this.loadPoints(slots.size());
        this.loadItems();
    }

    private void loadPoints(int num) {
        double centerx = (this.border.left() + this.border.right()) / 2.0;
        double centery = (this.border.top() + this.border.bottom()) / 2.0;
        this.itemPoints = new ArrayList();
        List targetPoints = MuseRenderer.pointsInLine(num, new MusePoint2D(centerx, this.border.bottom()), new MusePoint2D(centerx, this.border.top()));
        for (MusePoint2D point : targetPoints) {
            this.itemPoints.add(new FlyFromPointToPoint2D(new MusePoint2D(centerx, centery), point, 200.0));
        }
    }

    private void loadItems() {
        if (this.player != null) {
            this.itemButtons = new ArrayList();
            double centerx = (this.border.left() + this.border.right()) / 2.0;
            double centery = (this.border.top() + this.border.bottom()) / 2.0;
            List slots = MuseItemUtils.getModularItemSlotsInInventory((lt)this.player.bK);
            if (slots.size() > this.itemPoints.size()) {
                this.loadPoints(slots.size());
            }
            if (slots.size() > 0) {
                Iterator pointiterator = this.itemPoints.iterator();
                Iterator i$ = slots.iterator();
                while (i$.hasNext()) {
                    int slot = (Integer)i$.next();
                    ClickableItem clickie = new ClickableItem(this.player.bK.a(slot), (MusePoint2D)pointiterator.next(), slot);
                    this.itemButtons.add(clickie);
                }
            }
        }
    }

    @Override
    public void update(double mousex, double mousey) {
        this.loadItems();
    }

    @Override
    public void draw() {
        this.drawBackground();
        this.drawItems();
        this.drawSelection();
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        for (ClickableItem item : this.itemButtons) {
            item.draw();
        }
    }

    private void drawSelection() {
        if (this.selectedItemStack != -1) {
            MuseRenderer.drawCircleAround(Math.floor(((ClickableItem)this.itemButtons.get(this.selectedItemStack)).getPosition().x()), Math.floor(((ClickableItem)this.itemButtons.get(this.selectedItemStack)).getPosition().y()), 10.0);
        }
    }

    public boolean hasNoItems() {
        return this.itemButtons.size() == 0;
    }

    public ClickableItem getSelectedItem() {
        if (this.itemButtons.size() > this.selectedItemStack && this.selectedItemStack != -1) {
            return (ClickableItem)this.itemButtons.get(this.selectedItemStack);
        }
        return null;
    }

    @Override
    public void onMouseDown(double x2, double y, int button) {
        int i2 = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x2, y)) {
                this.selectedItemStack = i2;
                break;
            }
            ++i2;
        }
    }

    @Override
    public List getToolTip(int x2, int y) {
        int itemHover = -1;
        int i2 = 0;
        for (ClickableItem item : this.itemButtons) {
            if (item.hitBox(x2, y)) {
                itemHover = i2;
                break;
            }
            ++i2;
        }
        if (itemHover > -1) {
            return ((ClickableItem)this.itemButtons.get(itemHover)).getToolTip();
        }
        return null;
    }
}

