/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.Arrays;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import org.lwjgl.opengl.GL11;

public class ItemInfoFrame
extends ScrollableFrame {
    public static final double SCALEFACTOR = 0.5;
    protected ItemSelectionFrame target;
    protected sq player;
    protected List info;

    public ItemInfoFrame(sq player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super(topleft.times(2.0), bottomright.times(2.0), borderColour, insideColour);
        this.target = target;
        this.player = player;
    }

    @Override
    public void update(double mousex, double mousey) {
        ClickableItem selected = this.target.getSelectedItem();
        if (selected != null) {
            IModularItem item = MuseItemUtils.getAsModular(selected.getItem().b());
            this.info = item.getLongInfo(this.player, selected.getItem());
        } else {
            this.info = null;
        }
    }

    @Override
    public void draw() {
        if (this.info != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            super.draw();
            int xoffset = 8;
            int yoffset = 8;
            int i2 = 0;
            for (String infostring : this.info) {
                String[] str = infostring.split("\t");
                MuseRenderer.drawStringsJustified(Arrays.asList(str), this.border.left() + (double)xoffset, this.border.right() - (double)xoffset, this.border.top() + (double)yoffset + (double)(i2 * 10));
                ++i2;
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void onMouseDown(double x2, double y, int button) {
    }

    @Override
    public void onMouseUp(double x2, double y, int button) {
    }

    @Override
    public List getToolTip(int x2, int y) {
        return null;
    }
}

