/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableButton;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ModuleSelectionFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.powersuits.network.packets.MusePacketInstallModuleRequest;
import net.machinemuse.powersuits.network.packets.MusePacketSalvageModuleRequest;

@SideOnly(value=Side.CLIENT)
public class InstallSalvageFrame
extends ScrollableFrame {
    protected ItemSelectionFrame targetItem;
    protected ModuleSelectionFrame targetModule;
    protected ClickableButton installButton;
    protected ClickableButton salvageButton;
    protected bdw player;

    public InstallSalvageFrame(bdw player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame targetItem, ModuleSelectionFrame targetModule) {
        super(topleft, bottomright, borderColour, insideColour);
        this.player = player;
        this.targetItem = targetItem;
        this.targetModule = targetModule;
        double sizex = this.border.right() - this.border.left();
        double sizey = this.border.bottom() - this.border.top();
        this.installButton = new ClickableButton("Install", new MusePoint2D(this.border.right() - sizex / 2.0, this.border.bottom() - sizey / 4.0), true);
        this.salvageButton = new ClickableButton("Salvage", new MusePoint2D(this.border.left() + sizex / 2.0, this.border.top() + sizey / 4.0), true);
    }

    @Override
    public void update(double mousex, double mousey) {
    }

    @Override
    public List getToolTip(int x2, int y) {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            double xoffset;
            wm stack = this.targetItem.getSelectedItem().getItem();
            IPowerModule module = this.targetModule.getSelectedModule().getModule();
            List itemsToCheck = module.getInstallCost();
            double yoffset = !MuseItemUtils.itemHasModule(stack, module.getName()) ? this.border.top() + 4.0 : this.border.bottom() - 20.0;
            if (yoffset + 16.0 > (double)y && yoffset < (double)y && (xoffset = -8.0 * (double)itemsToCheck.size() + (this.border.left() + this.border.right()) / 2.0) + (double)(16 * itemsToCheck.size()) > (double)x2 && xoffset < (double)x2) {
                int index = (int)((double)x2 - xoffset) / 16;
                List tip = ((wm)itemsToCheck.get(index)).a((sq)this.player, false);
                return tip;
            }
        }
        return null;
    }

    @Override
    public void draw() {
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            this.drawBackground();
            this.drawItems();
            this.drawButtons();
        }
    }

    private void drawBackground() {
        super.draw();
    }

    private void drawItems() {
        wm stack = this.targetItem.getSelectedItem().getItem();
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        List itemsToDraw = module.getInstallCost();
        double yoffset = !MuseItemUtils.itemHasModule(stack, module.getName()) ? this.border.top() + 4.0 : this.border.bottom() - 20.0;
        double xoffset = -8.0 * (double)itemsToDraw.size() + (this.border.left() + this.border.right()) / 2.0;
        int i2 = 0;
        for (wm costItem : itemsToDraw) {
            MuseRenderer.drawItemAt((double)(16 * i2++) + xoffset, yoffset, costItem);
        }
    }

    private void drawButtons() {
        IPowerModule module;
        wm stack = this.targetItem.getSelectedItem().getItem();
        if (!MuseItemUtils.itemHasModule(stack, (module = this.targetModule.getSelectedModule().getModule()).getName())) {
            this.installButton.setEnabled(this.player.ce.d || MuseItemUtils.hasInInventory(module.getInstallCost(), this.player.bK));
            this.installButton.draw();
        } else {
            this.salvageButton.draw();
        }
    }

    @Override
    public void onMouseDown(double x2, double y, int button) {
        ClickableItem selItem = this.targetItem.getSelectedItem();
        ClickableModule selModule = this.targetModule.getSelectedModule();
        if (selItem != null && selModule != null) {
            IPowerModule module;
            wm stack = selItem.getItem();
            if (!MuseItemUtils.itemHasModule(stack, (module = selModule.getModule()).getName())) {
                if (this.installButton.hitBox(x2, y)) {
                    this.doInstall();
                }
            } else if (this.salvageButton.hitBox(x2, y)) {
                this.doSalvage();
            }
        }
    }

    private void doSalvage() {
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        MusePacketSalvageModuleRequest newpacket = new MusePacketSalvageModuleRequest((Player)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getName());
        this.player.a.c((ei)newpacket.getPacket250());
    }

    private void doInstall() {
        wm stack = this.targetItem.getSelectedItem().getItem();
        IPowerModule module = this.targetModule.getSelectedModule().getModule();
        if (this.player.ce.d || MuseItemUtils.hasInInventory(module.getInstallCost(), this.player.bK)) {
            MusePacketInstallModuleRequest newpacket = new MusePacketInstallModuleRequest((Player)this.player, this.targetItem.getSelectedItem().inventorySlot, module.getName());
            this.player.a.c((ei)newpacket.getPacket250());
        }
    }
}

