/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import java.util.List;
import net.machinemuse.api.MuseCommonStrings;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.DrawableMuseRect;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.Clickable;

public class ClickableSlider
extends Clickable {
    protected bs moduleTag;
    protected String name;
    protected double width;
    protected static final int cornersize = 2;
    protected DrawableMuseRect insideRect;
    protected DrawableMuseRect outsideRect;

    public ClickableSlider(MusePoint2D topmiddle, double width, bs moduleTag, String name) {
        this.moduleTag = moduleTag;
        this.name = name;
        this.position = topmiddle;
        this.width = width;
        this.outsideRect = new DrawableMuseRect(this.position.x() - width / 2.0 - 2.0, this.position.y() + 10.0, this.position.x() + width / 2.0 + 2.0, this.position.y() + 24.0, Colour.LIGHTBLUE, Colour.DARKBLUE);
        this.insideRect = new DrawableMuseRect(this.position.x() - width / 2.0 - 2.0, this.position.y() + 10.0, 0.0, this.position.y() + 24.0, Colour.LIGHTBLUE, Colour.ORANGE);
    }

    @Override
    public void draw() {
        MuseRenderer.drawCenteredString(this.name, this.position.x(), this.position.y());
        double value = MuseCommonStrings.getOrSetModuleProperty(this.moduleTag, this.name, 0.0);
        this.insideRect.setRight(this.position.x() + this.width * (value - 0.5) + 2.0);
        this.outsideRect.draw();
        this.insideRect.draw();
    }

    @Override
    public boolean hitBox(double x2, double y) {
        double xval = this.position.x() - x2;
        double yval = this.position.y() + 17.0 - y;
        return Math.abs(xval) < this.width / 2.0 && Math.abs(yval) < 7.0;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        double val = 0.0;
        if (this.moduleTag.b(this.name)) {
            val = this.moduleTag.h(this.name);
        }
        return val;
    }

    public void moveSlider(double x2, double y) {
        double xval = this.position.x() - x2;
        double xratio = 0.5 - xval / this.width;
        xratio = Math.max(Math.min(xratio, 1.0), 0.0);
        this.moduleTag.a(this.name, xratio);
    }

    @Override
    public List getToolTip() {
        return null;
    }
}

