/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.clickable;

import java.util.List;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.DrawableMuseRect;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.Clickable;

public class ClickableButton
extends Clickable {
    protected String label;
    protected MusePoint2D radius;
    protected DrawableMuseRect rect;
    protected boolean enabled;

    public ClickableButton(String label, MusePoint2D position, boolean enabled) {
        this.label = label;
        this.position = position;
        this.radius = new MusePoint2D(MuseRenderer.getFontRenderer().a(label) / 2 + 2, 6.0);
        this.rect = new DrawableMuseRect(position.x() - this.radius.x(), position.y() - this.radius.y(), position.x() + this.radius.x(), position.y() + this.radius.y(), new Colour(0.5, 0.6f, 0.8f, 1.0), new Colour(0.3f, 0.3f, 0.3f, 1.0));
        this.setEnabled(enabled);
    }

    @Override
    public void draw() {
        Colour bottomcolour;
        Colour topcolour;
        if (this.isEnabled()) {
            topcolour = new Colour(0.5, 0.6f, 0.8f, 1.0);
            bottomcolour = new Colour(0.3f, 0.3f, 0.3f, 1.0);
        } else {
            topcolour = new Colour(0.3f, 0.3f, 0.3f, 1.0);
            bottomcolour = new Colour(0.5, 0.6f, 0.8f, 1.0);
        }
        this.rect.setLeft(this.position.x() - this.radius.x());
        this.rect.setTop(this.position.y() - this.radius.y());
        this.rect.setRight(this.position.x() + this.radius.x());
        this.rect.setBottom(this.position.y() + this.radius.y());
        this.rect.setOutsideColour(topcolour);
        this.rect.setInsideColour(bottomcolour);
        this.rect.draw();
        MuseRenderer.drawCenteredString(this.label, this.position.x(), this.position.y() - 4.0);
    }

    @Override
    public boolean hitBox(double x2, double y) {
        boolean hitx = Math.abs(this.position.x() - x2) < this.radius.x();
        boolean hity = Math.abs(this.position.y() - y) < this.radius.y();
        return hitx && hity;
    }

    @Override
    public List getToolTip() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClickableButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

