/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.geometry;

import java.nio.DoubleBuffer;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import org.lwjgl.opengl.GL11;

public class SwirlyMuseCircle {
    public static final double detail = 4.0;
    protected DoubleBuffer points;
    protected DoubleBuffer colour;

    public SwirlyMuseCircle(Colour c1, Colour c2) {
        if (this.points == null) {
            this.points = MuseRenderer.getArcPoints(0.0, 6.283285307179586, 4.0, 0.0, 0.0, 0.0);
        }
        this.colour = MuseRenderer.getColourGradient(c1, c2, this.points.limit() / 3);
    }

    public void draw(double radius, double x2, double y) {
        int length = this.points.limit();
        double ratio = (double)(System.currentTimeMillis() % 2000L) / 2000.0;
        this.colour.rewind();
        this.points.rewind();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y, (double)0.0);
        GL11.glScaled((double)(radius / 4.0), (double)(radius / 4.0), (double)1.0);
        GL11.glRotatef((float)((float)(-ratio * 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        MuseRenderer.arraysOnC();
        MuseRenderer.texturelessOn();
        MuseRenderer.blendingOn();
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.colour);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.points);
        GL11.glDrawArrays((int)2, (int)0, (int)(length / 3));
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        MuseRenderer.arraysOff();
        MuseRenderer.texturelessOff();
        GL11.glPopMatrix();
    }
}

