/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.geometry;

import java.nio.DoubleBuffer;
import net.machinemuse.general.MuseRenderer;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.MuseRect;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DrawableMuseRect
extends MuseRect {
    MuseRect lastRect;
    Colour insideColour;
    Colour outsideColour;
    DoubleBuffer vertices;
    DoubleBuffer coloursInside;
    DoubleBuffer coloursOutside;

    public DrawableMuseRect(double left, double top, double right, double bottom, boolean growFromMiddle, Colour insideColour, Colour outsideColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
        if (growFromMiddle) {
            this.lastRect = new MuseRect(left, top, right, bottom);
        }
    }

    public DrawableMuseRect(double left, double top, double right, double bottom, Colour insideColour, Colour outsideColour) {
        super(left, top, right, bottom, false);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
    }

    public DrawableMuseRect(MusePoint2D ul2, MusePoint2D br, Colour insideColour, Colour outsideColour) {
        super(ul2, br);
        this.insideColour = insideColour;
        this.outsideColour = outsideColour;
    }

    public void draw() {
        if (this.vertices == null || this.coloursInside == null || this.coloursOutside == null || this.lastRect != null && !this.lastRect.equals(this)) {
            this.lastRect = new MuseRect(this.left(), this.top(), this.right(), this.bottom());
            double cornerradius = 4.0;
            double zLevel = 1.0;
            DoubleBuffer corner = MuseRenderer.getArcPoints(Math.PI, 4.71238898038469, cornerradius, this.left() + cornerradius, this.top() + cornerradius, zLevel);
            this.vertices = BufferUtils.createDoubleBuffer((int)(corner.limit() * 4));
            this.vertices.put(corner);
            corner = MuseRenderer.getArcPoints(4.71238898038469, Math.PI * 2, cornerradius, this.left() + cornerradius, this.bottom() - cornerradius, zLevel);
            this.vertices.put(corner);
            corner = MuseRenderer.getArcPoints(0.0, 1.5707963267948966, cornerradius, this.right() - cornerradius, this.bottom() - cornerradius, zLevel);
            this.vertices.put(corner);
            corner = MuseRenderer.getArcPoints(1.5707963267948966, Math.PI, cornerradius, this.right() - cornerradius, this.top() + cornerradius, zLevel);
            this.vertices.put(corner);
            this.vertices.flip();
            this.coloursInside = MuseRenderer.getColourGradient(this.outsideColour, this.outsideColour, this.vertices.limit() * 4 / 3 + 8);
            this.coloursOutside = MuseRenderer.getColourGradient(this.insideColour, this.insideColour, this.vertices.limit() * 4 / 3 + 8);
        }
        MuseRenderer.texturelessOn();
        MuseRenderer.blendingOn();
        MuseRenderer.on2D();
        MuseRenderer.arraysOnC();
        this.vertices.rewind();
        this.coloursOutside.rewind();
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.coloursOutside);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glDrawArrays((int)2, (int)0, (int)(this.vertices.limit() / 3));
        this.vertices.rewind();
        this.coloursInside.rewind();
        GL11.glColorPointer((int)4, (int)0, (DoubleBuffer)this.coloursInside);
        GL11.glVertexPointer((int)3, (int)0, (DoubleBuffer)this.vertices);
        GL11.glDrawArrays((int)6, (int)0, (int)(this.vertices.limit() / 3));
        MuseRenderer.off2D();
        MuseRenderer.texturelessOff();
        MuseRenderer.arraysOff();
    }

    public DrawableMuseRect setInsideColour(Colour insideColour) {
        this.insideColour = insideColour;
        return this;
    }

    public DrawableMuseRect setOutsideColour(Colour outsideColour) {
        this.outsideColour = outsideColour;
        return this;
    }
}

