/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.SwirlyMuseCircle;
import net.machinemuse.general.gui.MuseGui;
import net.machinemuse.general.gui.clickable.IClickable;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class MuseRenderer {
    protected static bhj renderItem;
    protected static SwirlyMuseCircle selectionCircle;
    public static String TEXTURE_MAP;

    public static void drawCircleAround(double xoffset, double yoffset, double radius) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0, 1.0, 0.0, 0.0), new Colour(0.8f, 1.0, 0.8f, 1.0));
        }
        selectionCircle.draw(radius, xoffset, yoffset);
    }

    public static List pointsInLine(int num, MusePoint2D a2, MusePoint2D b2) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        if (num < 1) {
            return points;
        }
        if (num < 2) {
            points.add(b2.minus(a2).times(0.5).plus(a2));
        } else {
            MusePoint2D step = b2.minus(a2).times(1.0f / (float)(num + 1));
            for (int i2 = 1; i2 < num + 1; ++i2) {
                points.add(a2.plus(step.times(i2)));
            }
        }
        return points;
    }

    public static DoubleBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numsegments * 4));
        for (double i2 = 0.0; i2 < (double)numsegments; i2 += 1.0) {
            Colour c3 = c1.interpolate(c2, i2 / (double)numsegments);
            buffer.put(c3.r);
            buffer.put(c3.g);
            buffer.put(c3.b);
            buffer.put(c3.a);
        }
        buffer.flip();
        return buffer;
    }

    public static DoubleBuffer getArcPoints(double startangle, double endangle, double radius, double xoffset, double yoffset, double zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((endangle - startangle) * 16.0 * Math.PI));
        double theta = (endangle - startangle) / (double)numVertices;
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numVertices * 3));
        double x2 = radius * Math.sin(startangle);
        double y = radius * Math.cos(startangle);
        double tf2 = Math.tan(theta);
        double rf2 = Math.cos(theta);
        for (int i2 = 0; i2 < numVertices; ++i2) {
            buffer.put(x2 + xoffset);
            buffer.put(y + yoffset);
            buffer.put(zoffset);
            double tx = y;
            double ty = -x2;
            x2 += tx * tf2;
            y += ty * tf2;
            x2 *= rf2;
            y *= rf2;
        }
        buffer.flip();
        return buffer;
    }

    public static void on2D() {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }

    public static void off2D() {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    public static void arraysOnC() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
    }

    public static void arraysOnT() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
    }

    public static void arraysOff() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32888);
    }

    public static void texturelessOn() {
        GL11.glDisable((int)3553);
    }

    public static void texturelessOff() {
        GL11.glEnable((int)3553);
    }

    public static void blendingOn() {
        if (Minecraft.t()) {
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void blendingOff() {
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2881);
        GL11.glDisable((int)3042);
    }

    public static void drawItemAt(double x2, double y, wm item) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        MuseRenderer.getRenderItem().b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x2, (int)y);
        MuseRenderer.getRenderItem().c(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x2, (int)y);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    public static void drawIconAt(double x2, double y, lx icon, Colour colour) {
        MuseRenderer.drawIconPartial(x2, y, icon, colour, 0.0, 0.0, 16.0, 16.0);
    }

    public static void drawIconPartial(double x2, double y, lx icon, Colour colour, double left, double top, double right, double bottom) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        MuseRenderer.texturelessOff();
        MuseRenderer.blendingOn();
        if (colour != null) {
            colour.doGL();
        }
        MuseRenderer.getRenderEngine().b(TEXTURE_MAP);
        bge tess = bge.a;
        tess.b();
        float u1 = icon.e();
        float v1 = icon.g();
        float u2 = icon.f();
        float v2 = icon.h();
        double xoffset1 = left * (double)(u2 - u1) / 16.0;
        double yoffset1 = top * (double)(v2 - v1) / 16.0;
        double xoffset2 = right * (double)(u2 - u1) / 16.0;
        double yoffset2 = bottom * (double)(v2 - v1) / 16.0;
        tess.a(x2 + left, y + top, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset1);
        tess.a(x2 + left, y + bottom, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset2);
        tess.a(x2 + right, y + bottom, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset2);
        tess.a(x2 + right, y + top, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset1);
        tess.a();
        MuseRenderer.blendingOff();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void relativeCoords(MuseGui gui) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(gui.g / 2), (float)(gui.h / 2), (float)0.0f);
        GL11.glScalef((float)gui.getxSize(), (float)gui.getySize(), (float)0.0f);
    }

    public static void drawString(String s2, double x2, double y) {
        avb.a();
        MuseRenderer.getFontRenderer().a(s2, (int)x2, (int)y, new Colour(1.0, 1.0, 1.0, 1.0).getInt());
    }

    public static void drawCenteredString(String s2, double x2, double y) {
        double xradius = MuseRenderer.getFontRenderer().a(s2) / 2;
        MuseRenderer.drawString(s2, x2 - xradius, y);
    }

    public static void drawRectPrism(double x2, double d, double e, double f, double z, double g, float texturex, float texturey, float texturex2, float texturey2) {
        MuseRenderer.arraysOnT();
        MuseRenderer.texturelessOff();
        arc[] points = new arc[]{arc.a((double)x2, (double)e, (double)z), arc.a((double)d, (double)e, (double)z), arc.a((double)x2, (double)f, (double)z), arc.a((double)d, (double)f, (double)z), arc.a((double)x2, (double)e, (double)g), arc.a((double)d, (double)e, (double)g), arc.a((double)x2, (double)f, (double)g), arc.a((double)d, (double)f, (double)g)};
        bcu[] va1 = new bcu[]{new bcu(points[0], texturex, texturey2), new bcu(points[2], texturex2, texturey2), new bcu(points[3], texturex2, texturey), new bcu(points[1], texturex, texturey)};
        new bch(va1).a(bge.a, 1.0f);
        bcu[] va2 = new bcu[]{new bcu(points[2], texturex, texturey2), new bcu(points[6], texturex2, texturey2), new bcu(points[7], texturex2, texturey), new bcu(points[3], texturex, texturey)};
        new bch(va2).a(bge.a, 1.0f);
        bcu[] va3 = new bcu[]{new bcu(points[6], texturex, texturey2), new bcu(points[4], texturex2, texturey2), new bcu(points[5], texturex2, texturey), new bcu(points[7], texturex, texturey)};
        new bch(va3).a(bge.a, 1.0f);
        bcu[] va4 = new bcu[]{new bcu(points[4], texturex, texturey2), new bcu(points[0], texturex2, texturey2), new bcu(points[1], texturex2, texturey), new bcu(points[5], texturex, texturey)};
        new bch(va4).a(bge.a, 1.0f);
        bcu[] va5 = new bcu[]{new bcu(points[1], texturex, texturey2), new bcu(points[3], texturex2, texturey2), new bcu(points[7], texturex2, texturey), new bcu(points[5], texturex, texturey)};
        new bch(va5).a(bge.a, 1.0f);
        bcu[] va6 = new bcu[]{new bcu(points[0], texturex, texturey2), new bcu(points[4], texturex2, texturey2), new bcu(points[6], texturex2, texturey), new bcu(points[2], texturex, texturey)};
        new bch(va6).a(bge.a, 1.0f);
        MuseRenderer.texturelessOff();
        MuseRenderer.arraysOff();
    }

    public static void drawStringsJustified(List words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth += MuseRenderer.getFontRenderer().a(word);
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            MuseRenderer.drawString(word, x1 + currentwidth, y);
            currentwidth += (double)MuseRenderer.getFontRenderer().a(word) + spacing;
        }
    }

    public static void glowOn() {
        avb.a();
        bkn.a((int)bkn.b, (float)240.0f, (float)240.0f);
    }

    public static void glowOff() {
        avb.b();
    }

    public static awv getFontRenderer() {
        return Minecraft.x().q;
    }

    public static bgf getRenderEngine() {
        return Minecraft.x().p;
    }

    public static bhj getRenderItem() {
        if (renderItem == null) {
            renderItem = new bhj();
        }
        return renderItem;
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        double gradientRatio = 1.0 - (double)((varia + 1000L) % 1000L) / 1000.0;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times(Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        gradientColour.withAlpha(0.0).doGL();
        GL11.glVertex3d((double)firstpoint.x(), (double)firstpoint.y(), (double)1.0);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)secondpoint.x(), (double)secondpoint.y(), (double)1.0);
        Colour.WHITE.withAlpha(1.0).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double cx2 = 0.0;
        double cy2 = 0.0;
        double cz2 = 0.0;
        double jagfactor = 0.3;
        MuseRenderer.texturelessOn();
        MuseRenderer.blendingOn();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glBegin((int)3);
        while (Math.abs(cx2) < Math.abs(tx) && Math.abs(cy2) < Math.abs(ty) && Math.abs(cz2) < Math.abs(tz)) {
            colour.doGL();
            double ox = x1 + cx2;
            double oy = y1 + cy2;
            double oz = z1 + cz2;
            GL11.glVertex3d((double)(x1 + (cx2 += Math.random() * tx * jagfactor - 0.1 * tx)), (double)(y1 + (cy2 += Math.random() * ty * jagfactor - 0.1 * ty)), (double)(z1 + (cz2 += Math.random() * tz * jagfactor - 0.1 * tz)));
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        MuseRenderer.texturelessOff();
    }

    static {
        TEXTURE_MAP = "/gui/items.png";
    }
}

