/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import net.machinemuse.api.electricity.ElectricAdapter;
import net.machinemuse.powersuits.common.ModCompatability;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class UEElectricAdapter
extends ElectricAdapter {
    protected wm stack;
    protected IItemElectric item;

    public UEElectricAdapter(wm stack) {
        this.stack = stack;
        this.item = (IItemElectric)((Object)stack.b());
    }

    @Override
    public double getCurrentEnergy() {
        double currentEnergy = UEElectricAdapter.museEnergyFromJoules(this.item.getJoules(this.stack));
        return currentEnergy;
    }

    @Override
    public double getMaxEnergy() {
        double maxEnergy = UEElectricAdapter.museEnergyFromJoules(this.item.getMaxJoules(this.stack));
        return maxEnergy;
    }

    @Override
    public double drainEnergy(double requested) {
        double voltage = this.item.getVoltage(this.stack);
        ElectricityPack requestedPack = UEElectricAdapter.museEnergyToElectricityPack(requested, voltage);
        ElectricityPack receivedPack = this.item.onProvide(requestedPack, this.stack);
        return UEElectricAdapter.museEnergyFromElectricityPack(receivedPack);
    }

    @Override
    public double giveEnergy(double provided) {
        double voltage = this.item.getVoltage(this.stack);
        ElectricityPack packToProvide = UEElectricAdapter.museEnergyToElectricityPack(provided, voltage);
        ElectricityPack eatenPack = this.item.onReceive(packToProvide, this.stack);
        return UEElectricAdapter.museEnergyFromElectricityPack(eatenPack);
    }

    public static ElectricityPack museEnergyToElectricityPack(double museEnergy, double voltage) {
        double coulombsPerTick = UEElectricAdapter.museEnergyToJoules(museEnergy);
        double amps = coulombsPerTick * 20.0 / voltage;
        return new ElectricityPack(amps, voltage);
    }

    public static double museEnergyFromElectricityPack(ElectricityPack pack) {
        double coulombsPerTick = pack.amperes / 20.0 * pack.voltage;
        double museEnergy = UEElectricAdapter.museEnergyFromJoules(coulombsPerTick);
        return museEnergy;
    }

    public static double museEnergyToJoules(double energy) {
        return energy / ModCompatability.getUERatio();
    }

    public static double museEnergyFromJoules(double energy) {
        return energy * ModCompatability.getUERatio();
    }
}

