/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.MuseMathUtils;
import net.machinemuse.powersuits.item.ItemComponent;

public class MuseItemUtils {
    public static final String NBTPREFIX = "mmmpsmod";
    public static final String ONLINE = "Active";

    public static List getValidModulesForItem(sq player, wm stack) {
        ArrayList<IPowerModule> validModules = new ArrayList<IPowerModule>();
        for (IPowerModule module : ModuleManager.getAllModules()) {
            if (!module.isValidForItem(stack, player)) continue;
            validModules.add(module);
        }
        return validModules;
    }

    public static boolean tagHasModule(bs tag, String moduleName) {
        return tag.b(moduleName);
    }

    public static List getValidModes(wm stack, sq player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule)) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static List getModes(wm stack, sq player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule) || !MuseItemUtils.itemHasModule(stack, module.getName())) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static boolean isModuleOnline(bs itemTag, String moduleName) {
        if (MuseItemUtils.tagHasModule(itemTag, moduleName) && !itemTag.l(moduleName).b(ONLINE)) {
            return true;
        }
        return MuseItemUtils.tagHasModule(itemTag, moduleName) && itemTag.l(moduleName).n(ONLINE);
    }

    public static void toggleModule(bs itemTag, String name, boolean toggleval) {
        if (MuseItemUtils.tagHasModule(itemTag, name)) {
            bs moduleTag = itemTag.l(name);
            moduleTag.a(ONLINE, toggleval);
        }
    }

    public static boolean itemHasModule(wm stack, String moduleName) {
        return MuseItemUtils.tagHasModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static void tagAddModule(bs tag, IPowerModule module) {
        tag.a(module.getName(), module.getNewTag());
    }

    public static void itemAddModule(wm stack, IPowerModule moduleType) {
        MuseItemUtils.tagAddModule(MuseItemUtils.getMuseItemTag(stack), moduleType);
    }

    public static boolean removeModule(bs tag, String moduleName) {
        if (tag.b(moduleName)) {
            tag.o(moduleName);
            return true;
        }
        return false;
    }

    public static boolean removeModule(wm stack, String moduleName) {
        return MuseItemUtils.removeModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static bs getMuseItemTag(wm stack) {
        bs properties;
        bs stackTag;
        if (stack == null) {
            return null;
        }
        if (stack.p()) {
            stackTag = stack.q();
        } else {
            stackTag = new bs();
            stack.d(stackTag);
        }
        if (stackTag.b(NBTPREFIX)) {
            properties = stackTag.l(NBTPREFIX);
        } else {
            properties = new bs();
            stackTag.a(NBTPREFIX, properties);
        }
        return properties;
    }

    public static List getModularItemsInInventory(lt inv) {
        ArrayList<wm> stacks = new ArrayList<wm>();
        for (int i2 = 0; i2 < inv.j_(); ++i2) {
            wm stack = inv.a(i2);
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static List getModularItemsInInventory(sq player) {
        return MuseItemUtils.getModularItemsInInventory((lt)player.bK);
    }

    public static List getModularItemSlotsInInventory(lt inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inv.j_(); ++i2) {
            wm stack = inv.a(i2);
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            slots.add(i2);
        }
        return slots;
    }

    public static IModularItem getAsModular(wk item) {
        if (item instanceof IModularItem) {
            return (IModularItem)((Object)item);
        }
        return null;
    }

    public static boolean hasInInventory(List workingUpgradeCost, so inventory) {
        for (wm stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i2 = 0; i2 < inventory.j_(); ++i2) {
                wm stackInInventory = inventory.a(i2);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.a;
            }
            if (found >= stackInCost.a) continue;
            return false;
        }
        return true;
    }

    public static List deleteFromInventory(List cost, so inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (wm stackInCost : cost) {
            int remaining = stackInCost.a;
            for (int i2 = 0; i2 < inventory.j_() && remaining > 0; ++i2) {
                wm stackInInventory = inventory.a(i2);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                int numToTake = Math.min(stackInInventory.a, remaining);
                stackInInventory.a -= numToTake;
                remaining -= numToTake;
                if (stackInInventory.a == 0) {
                    inventory.a(i2, null);
                }
                slots.add(i2);
            }
        }
        return slots;
    }

    public static List findInInventoryForCost(List workingUpgradeCost, so inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (wm stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i2 = 0; i2 < inventory.j_() && found < stackInCost.a; ++i2) {
                wm stackInInventory = inventory.a(i2);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.a;
                slots.add(i2);
            }
        }
        return slots;
    }

    public static double getDoubleOrZero(bs itemProperties, String string) {
        double value = 0.0;
        if (itemProperties != null && itemProperties.b(string)) {
            value = itemProperties.h(string);
        }
        return value;
    }

    public static double getDoubleOrZero(wm stack, String string) {
        return MuseItemUtils.getDoubleOrZero(MuseItemUtils.getMuseItemTag(stack), string);
    }

    public static void setDoubleOrRemove(bs itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.o(string);
            } else {
                itemProperties.a(string, value);
            }
        }
    }

    public static void setDoubleOrRemove(wm stack, String string, double value) {
        MuseItemUtils.setDoubleOrRemove(MuseItemUtils.getMuseItemTag(stack), string, value);
    }

    public static String getStringOrNull(bs itemProperties, String key) {
        String value = null;
        if (itemProperties != null && itemProperties.b(key)) {
            value = itemProperties.i(key);
        }
        return value;
    }

    public static String getStringOrNull(wm stack, String key) {
        return MuseItemUtils.getStringOrNull(MuseItemUtils.getMuseItemTag(stack), key);
    }

    public static void setStringOrNull(bs itemProperties, String key, String value) {
        if (itemProperties != null) {
            if (value.equals("")) {
                itemProperties.o(key);
            } else {
                itemProperties.a(key, value);
            }
        }
    }

    public static void setStringOrNull(wm stack, String key, String value) {
        MuseItemUtils.setStringOrNull(MuseItemUtils.getMuseItemTag(stack), key, value);
    }

    public static List modularItemsEquipped(sq player) {
        wm[] equipped;
        ArrayList<wm> modulars = new ArrayList<wm>(5);
        for (wm stack : equipped = MuseItemUtils.itemsEquipped(player)) {
            if (stack == null || !(stack.b() instanceof IModularItem)) continue;
            modulars.add(stack);
        }
        return modulars;
    }

    public static wm[] itemsEquipped(sq player) {
        wm[] equipped = new wm[]{player.bK.b[0], player.bK.b[1], player.bK.b[2], player.bK.b[3], player.bK.h()};
        return equipped;
    }

    public static boolean canStackTogether(wm stack1, wm stack2) {
        if (!MuseItemUtils.isSameItem(stack1, stack2)) {
            return false;
        }
        if (!stack1.f()) {
            return false;
        }
        return stack1.a < stack1.e();
    }

    public static boolean isSameItem(wm stack1, wm stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.c != stack2.c) {
            return false;
        }
        return stack1.g() || stack1.k() == stack2.k();
    }

    public static void transferStackWithChance(wm itemsToGive, wm destinationStack, double chanceOfSuccess) {
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.lvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.mvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.hvcapacitor)) {
            itemsToGive.a = 0;
            return;
        }
        int maxSize = destinationStack.e();
        while (itemsToGive.a > 0 && destinationStack.a < maxSize) {
            --itemsToGive.a;
            if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
            ++destinationStack.a;
        }
    }

    public static Set giveOrDropItems(wm itemsToGive, sq player) {
        return MuseItemUtils.giveOrDropItemWithChance(itemsToGive, player, 1.0);
    }

    public static Set giveOrDropItemWithChance(wm itemsToGive, sq player, double chanceOfSuccess) {
        int i2;
        HashSet<Integer> slots = new HashSet<Integer>();
        for (i2 = 0; i2 < player.bK.j_() && itemsToGive.a > 0; ++i2) {
            wm currentStack = player.bK.a(i2);
            if (!MuseItemUtils.canStackTogether(currentStack, itemsToGive)) continue;
            slots.add(i2);
            MuseItemUtils.transferStackWithChance(itemsToGive, currentStack, chanceOfSuccess);
        }
        for (i2 = 0; i2 < player.bK.j_() && itemsToGive.a > 0; ++i2) {
            if (player.bK.a(i2) != null) continue;
            wm destination = new wm(itemsToGive.c, 0, itemsToGive.k());
            MuseItemUtils.transferStackWithChance(itemsToGive, destination, chanceOfSuccess);
            if (destination.a <= 0) continue;
            player.bK.a(i2, destination);
            slots.add(i2);
        }
        if (itemsToGive.a > 0) {
            for (i2 = 0; i2 < itemsToGive.a; ++i2) {
                if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
                wm copyStack = itemsToGive.m();
                copyStack.a = 1;
                player.c(copyStack);
            }
        }
        return slots;
    }

    public static double getPlayerWeight(sq player) {
        double weight = 0.0;
        for (wm stack : MuseItemUtils.modularItemsEquipped(player)) {
            weight += ModuleManager.computeModularProperty(stack, "Weight");
        }
        return weight;
    }

    public static List getPlayerInstalledModules(sq player) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        for (wm stack : MuseItemUtils.modularItemsEquipped(player)) {
            bs itemTag = MuseItemUtils.getMuseItemTag(stack);
            for (IPowerModule module : MuseItemUtils.getValidModulesForItem(player, stack)) {
                if (!MuseItemUtils.tagHasModule(itemTag, module.getName())) continue;
                installedModules.add(module);
            }
        }
        return installedModules;
    }

    public static void toggleModuleForPlayer(sq player, String name, boolean toggleval) {
        for (wm stack : MuseItemUtils.modularItemsEquipped(player)) {
            bs itemTag = MuseItemUtils.getMuseItemTag(stack);
            MuseItemUtils.toggleModule(itemTag, name, toggleval);
        }
    }

    public static boolean itemHasActiveModule(wm itemStack, String moduleName) {
        IPowerModule module = ModuleManager.getModule(moduleName);
        if (module == null || !module.isAllowed()) {
            return false;
        }
        if (module != null && module instanceof IRightClickModule) {
            return moduleName.equals(MuseItemUtils.getActiveMode(itemStack));
        }
        return MuseItemUtils.isModuleOnline(MuseItemUtils.getMuseItemTag(itemStack), moduleName);
    }

    public static String getActiveMode(wm itemStack) {
        return MuseItemUtils.getMuseItemTag(itemStack).i("Mode");
    }

    public static wm copyAndResize(wm stack, int number) {
        wm copy = stack.m();
        copy.a = number;
        return copy;
    }
}

