/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.LinkedList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricAdapter;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemPowerGauntlet;

public abstract class MuseCommonStrings {
    public static final String ARMOR_VALUE_PHYSICAL = "Armor (Physical)";
    public static final String ARMOR_VALUE_ENERGY = "Armor (Energy)";
    public static final String ARMOR_ENERGY_CONSUMPTION = "Energy Per Damage";
    public static final String WEIGHT = "Weight";
    public static final String RED_TINT = "Red Tint";
    public static final String GREEN_TINT = "Green Tint";
    public static final String BLUE_TINT = "Blue Tint";
    public static final String PUNCH_ENERGY = "Punch Energy Consumption";
    public static final String PUNCH_DAMAGE = "Melee Damage";
    public static final String PUNCH_KNOCKBACK = "Melee Knockback";
    public static final String MODULE_BATTERY_BASIC = "Basic Battery";
    public static final String MODULE_BATTERY_ADVANCED = "Advanced Battery";
    public static final String MODULE_BATTERY_ELITE = "Elite Battery";
    public static final String MODULE_BASIC_PLATING = "Iron Plating";
    public static final String MODULE_DIAMOND_PLATING = "Diamond Plating";
    public static final String MODULE_ENERGY_SHIELD = "Energy Shield";
    public static final String MODULE_TRANSPARENT_ARMOR = "Transparent Armor";
    public static final String MODULE_ANTIGRAVITY = "Antigravity Drive";
    public static final String MODULE_TINT = "Custom Colour Module";
    public static final String MODULE_MELEE_ASSIST = "Melee Assist";
    public static final String CITIZEN_JOE_STYLE = "Citizen Joe Style";
    public static final String MODULE_HAZMAT = "Radiation Shielding";
    public static final String CATEGORY_ARMOR = "Armor";
    public static final String CATEGORY_ENERGY = "Energy";
    public static final String CATEGORY_TOOL = "Tool";
    public static final String CATEGORY_WEAPON = "Weapon";
    public static final String CATEGORY_MOVEMENT = "Movement";
    public static final String CATEGORY_COSMETIC = "Cosmetic";
    public static final String CATEGORY_VISION = "Vision";
    public static final String CATEGORY_ENVIRONMENTAL = "Environment";
    public static final String CATEGORY_SPECIAL = "Special";
    private static final String SOUND_RESOURCE_LOCATION = "resources/machinemuse/sound/";
    private static final String SOUND_PREFIX = "resources.machinemuse.sound.";
    public static String[] soundFiles = new String[]{"resources/machinemuse/sound/Glider.ogg", "resources/machinemuse/sound/GUIInstall.ogg", "resources/machinemuse/sound/GUISelect.ogg", "resources/machinemuse/sound/JetBoots.ogg", "resources/machinemuse/sound/Jetpack.ogg", "resources/machinemuse/sound/JumpAssist.ogg", "resources/machinemuse/sound/SwimAssist.ogg", "resources/machinemuse/sound/WaterElectrolyzer.ogg"};
    public static final String SOUND_GLIDER = "resources.machinemuse.sound.Glider";
    public static final String SOUND_GUI_INSTALL = "resources.machinemuse.sound.GUIInstall";
    public static final String SOUND_GUI_SELECT = "resources.machinemuse.sound.GUISelect";
    public static final String SOUND_JET_BOOTS = "resources.machinemuse.sound.JetBoots";
    public static final String SOUND_JETPACK = "resources.machinemuse.sound.Jetpack";
    public static final String SOUND_JUMP_ASSIST = "resources.machinemuse.sound.JumpAssist";
    public static final String SOUND_SWIM_ASSIST = "resources.machinemuse.sound.SwimAssist";
    public static final String SOUND_WATER_ELECTROLYZER = "resources.machinemuse.sound.WaterElectrolyzer";

    public static void addInformation(wm stack, sq player, List currentTipList, boolean advancedToolTips) {
        ElectricAdapter adapter;
        if (stack.b() instanceof ItemPowerGauntlet) {
            String mode = MuseItemUtils.getStringOrNull(stack, "Mode");
            if (mode != null) {
                currentTipList.add("Mode:" + MuseStringUtils.wrapFormatTags(mode, MuseStringUtils.FormatCodes.Red));
            } else {
                currentTipList.add("Change modes: Sneak+mousewheel.");
            }
        }
        if ((adapter = ElectricAdapter.wrap(stack)) != null) {
            String energyinfo = "Energy: " + MuseStringUtils.formatNumberShort(adapter.getCurrentEnergy()) + "/" + MuseStringUtils.formatNumberShort(adapter.getMaxEnergy());
            currentTipList.add(MuseStringUtils.wrapMultipleFormatTags(energyinfo, new Object[]{Character.valueOf(MuseStringUtils.FormatCodes.Italic.character), MuseStringUtils.FormatCodes.Grey}));
        }
        if (Config.doAdditionalInfo()) {
            List installed = MuseCommonStrings.getItemInstalledModules(player, stack);
            if (installed.size() == 0) {
                String message = "No installed modules! This item is useless until you add some modules at a Tinker Table.";
                currentTipList.addAll(MuseStringUtils.wrapStringToLength(message, 30));
            } else {
                currentTipList.add("Installed Modules:");
                currentTipList.addAll(installed);
            }
        } else {
            currentTipList.add(Config.additionalInfoInstructions());
        }
    }

    public static double getOrSetModuleProperty(bs moduleTag, String propertyName, double defaultValue) {
        if (!moduleTag.b(propertyName)) {
            moduleTag.a(propertyName, defaultValue);
        }
        return moduleTag.h(propertyName);
    }

    public static double getTotalWeight(wm stack) {
        return ModuleManager.computeModularProperty(stack, WEIGHT);
    }

    public static List getItemInstalledModules(sq player, wm stack) {
        bs itemTag = MuseItemUtils.getMuseItemTag(stack);
        LinkedList<String> modules = new LinkedList<String>();
        for (IPowerModule module : MuseItemUtils.getValidModulesForItem(player, stack)) {
            if (!MuseItemUtils.tagHasModule(itemTag, module.getName())) continue;
            modules.add(module.getName());
        }
        return modules;
    }
}

