/*
 * Decompiled with CFR 0.152.
 */
package fr.shayana.votekick;

import fr.shayana.votekick.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class BansStorage {
    protected Main plugin;
    private FileConfiguration tempbans = null;
    private File tempbanFile = null;
    private FileConfiguration bans = null;
    private File bansFile = null;

    public BansStorage(Main plugin) {
        this.plugin = plugin;
    }

    public void reloadCustomConfig() {
        InputStream deftempConf;
        InputStream defbanConf;
        if (this.bansFile == null) {
            this.bansFile = new File(this.plugin.getDataFolder(), "bans.yml");
        }
        if (this.tempbanFile == null) {
            this.tempbanFile = new File(this.plugin.getDataFolder(), "tempbans.yml");
        }
        this.tempbans = YamlConfiguration.loadConfiguration((File)this.tempbanFile);
        this.bans = YamlConfiguration.loadConfiguration((File)this.bansFile);
        if (!this.bansFile.exists() && (defbanConf = this.plugin.getResource("bans.yml")) != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defbanConf);
            this.bans.setDefaults((Configuration)defConfig);
        }
        if (!this.tempbanFile.exists() && (deftempConf = this.plugin.getResource("tempbans.yml")) != null) {
            YamlConfiguration deftempConfig = YamlConfiguration.loadConfiguration((InputStream)deftempConf);
            this.tempbans.setDefaults((Configuration)deftempConfig);
        }
    }

    public FileConfiguration getBans() {
        if (this.bans == null) {
            this.reloadCustomConfig();
        }
        return this.bans;
    }

    public FileConfiguration getTemps() {
        if (this.tempbans == null) {
            this.reloadCustomConfig();
        }
        return this.tempbans;
    }

    public void saveBans() {
        if (this.bans == null || this.bansFile == null) {
            return;
        }
        try {
            this.bans.save(this.bansFile);
        }
        catch (IOException ex) {
            Logger.getLogger(this.plugin.getName()).log(Level.SEVERE, "Could not save config to " + this.bansFile, ex);
        }
    }

    public void saveTemps() {
        if (this.tempbans == null || this.tempbanFile == null) {
            return;
        }
        try {
            this.tempbans.save(this.tempbanFile);
        }
        catch (IOException ex) {
            Logger.getLogger(this.plugin.getName()).log(Level.SEVERE, "Could not save config to " + this.bansFile, ex);
        }
    }

    public void ban(Player player, String reason) {
        String p = player.getName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Reason", reason);
        this.bans.createSection(p, map);
        this.saveBans();
    }

    public void tempBan(Player player, String reason, Long time) {
        String p = player.getName();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Reason", reason);
        map.put("Until", time);
        this.tempbans.createSection(p, map);
        this.saveTemps();
    }

    public boolean isBanned(Player player) {
        String p = player.getName();
        return this.getBans().contains(p);
    }

    public boolean isTemp(Player player) {
        boolean pbanned = false;
        String p = player.getName();
        if (this.getTemps().contains(p)) {
            pbanned = this.getTemps().getLong(String.valueOf(p) + ".Until") < System.currentTimeMillis();
        }
        return pbanned;
    }

    public String remainingTime(Player p) {
        String t = null;
        return t;
    }
}

