/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(int id, int index) {
        super(id, index);
        this.e(160);
        this.d(1);
    }

    public boolean canTakeDamage(ur stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(ur itemstack, qx entityPlayer, yc world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        int blockId = world.a(x, y, z);
        int metaData = world.h(x, y, z);
        any tileEntity = world.q(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (IC2.keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.ah() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.ah()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (this.canTakeDamage(itemstack, 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (IC2.platform.isSimulating()) {
                    if (IC2.enableLoggingWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                        MinecraftServer.D();
                        MinecraftServer.a.log(Level.INFO, "Player " + entityPlayer.bR + " used the wrench to remove the " + blockName + " (" + blockId + "-" + metaData + ") at " + x + "/" + y + "/" + z);
                    }
                    amq block = amq.p[blockId];
                    ArrayList drops = block.getBlockDropped(world, x, y, z, metaData, 0);
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canTakeDamage(itemstack, 200)) {
                            IC2.platform.messagePlayer(entityPlayer, "Not enough energy for lossless wrench operation");
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    } else {
                        dropOriginalBlock = world.t.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.damage(itemstack, 10, entityPlayer);
                    }
                    if (dropOriginalBlock) {
                        if (drops.isEmpty()) {
                            drops.add(wrenchable.getWrenchDrop(entityPlayer));
                        } else {
                            drops.set(0, wrenchable.getWrenchDrop(entityPlayer));
                        }
                    }
                    for (ur itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.e(x, y, z, 0);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
        }
        return false;
    }

    public void damage(ur is, int damage, qx player) {
        is.a(damage, (md)player);
    }

    public boolean overrideWrenchSuccessRate(ur itemStack) {
        return false;
    }
}

