/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.personal.ContainerEnergyOMatClosed;
import ic2.core.block.personal.ContainerEnergyOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.util.StackUtil;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityEnergyOMat
extends TileEntityMachine
implements IPersonalBlock,
IHasGui,
ISidedInventory,
IEnergySink,
IEnergySource,
INetworkClientTileEntityEventListener {
    private static final Direction[] directions = Direction.values();
    public int euOffer = 1000;
    public String owner = "null";
    private boolean addedToEnergyNet = false;
    public int paidFor;
    public int euBuffer;
    private int euBufferMax = 10000;
    private int maxOutputRate = 32;

    public TileEntityEnergyOMat() {
        super(3);
    }

    @Override
    public String b() {
        return "Energy-O-Mat";
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.owner = nbttagcompound.i("owner");
        this.euOffer = nbttagcompound.e("euOffer");
        this.paidFor = nbttagcompound.e("paidFor");
        this.euBuffer = nbttagcompound.e("euBuffer");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("owner", this.owner);
        nbttagcompound.a("euOffer", this.euOffer);
        nbttagcompound.a("paidFor", this.paidFor);
        nbttagcompound.a("euBuffer", this.euBuffer);
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return this.canAccess(entityPlayer);
    }

    @Override
    public boolean canAccess(qx player) {
        if (this.owner.equals("null")) {
            this.owner = player.bR;
            return true;
        }
        return this.owner.equalsIgnoreCase(player.bR);
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void g() {
        super.g();
        if (IC2.platform.isSimulating()) {
            this.euBufferMax = 10000;
            this.maxOutputRate = 32;
            if (this.inventory[2] != null) {
                if (this.inventory[2].a(Ic2Items.energyStorageUpgrade)) {
                    this.euBufferMax = 10000 * (this.inventory[2].a + 1);
                } else if (this.inventory[2].a(Ic2Items.transformerUpgrade)) {
                    this.maxOutputRate = 32 * (int)Math.pow(4.0, Math.min(4, this.inventory[2].a));
                }
            }
            if (this.inventory[1] != null && this.inventory[0] != null && this.inventory[1].a(this.inventory[0])) {
                Direction direction;
                any target;
                this.paidFor += this.euOffer / this.inventory[0].a * this.inventory[1].a;
                Direction[] arr$ = directions;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (!((target = (direction = arr$[i$]).applyToTileEntity(this)) instanceof la) || target instanceof TileEntityPersonalChest && !((TileEntityPersonalChest)target).owner.equals(this.owner) || !StackUtil.putInInventory((la)target, this.inventory[1])); ++i$) {
                }
                this.inventory[1] = null;
                this.d();
            }
            if (this.euBuffer > this.euBufferMax) {
                this.euBuffer = this.euBufferMax;
            }
            int min = Math.min(this.maxOutputRate, this.euBuffer);
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, min);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.euBuffer -= min - event.amount;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return this.getFacing() != side && this.canAccess(entityPlayer);
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public int getMaxEnergyOutput() {
        return 32;
    }

    @Override
    public int demandsEnergy() {
        return Math.min(this.paidFor, this.euBufferMax - this.euBuffer);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        int toAdd = Math.min(Math.min(amount, this.paidFor), this.euBufferMax - this.euBuffer);
        this.paidFor -= toAdd;
        this.euBuffer += toAdd;
        return amount - toAdd;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return new ContainerEnergyOMatOpen(entityPlayer, this);
        }
        return new ContainerEnergyOMatClosed(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        if (this.canAccess(entityPlayer)) {
            return "block.personal.GuiEnergyOMatOpen";
        }
        return "block.personal.GuiEnergyOMatClosed";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    @Override
    public void onNetworkEvent(qx player, int event) {
        if (!this.canAccess(player)) {
            return;
        }
        switch (event) {
            case 0: {
                this.attemptSet(-1000);
                break;
            }
            case 1: {
                this.attemptSet(-100);
                break;
            }
            case 2: {
                this.attemptSet(1000);
                break;
            }
            case 3: {
                this.attemptSet(100);
            }
        }
    }

    private void attemptSet(int amount) {
        if (this.euOffer + amount <= 0) {
            amount = 0;
        }
        this.euOffer += amount;
    }
}

