/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityTesla
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 10000;
    public int maxInput = 128;
    public boolean addedToEnergyNet = false;

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.d("energy");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    public void g() {
        super.g();
        if (!IC2.platform.isSimulating() || !this.redstoned()) {
            return;
        }
        if (this.energy < TileEntityTesla.getCost()) {
            return;
        }
        int damage = this.energy / TileEntityTesla.getCost();
        --this.energy;
        if (this.ticker++ % 32 == 0 && this.shock(damage)) {
            this.energy = 0;
        }
    }

    public boolean shock(int damage) {
        boolean shock = false;
        List list1 = this.k.a(md.class, aoe.a((double)(this.l - 4), (double)(this.m - 4), (double)(this.n - 4), (double)(this.l + 5), (double)(this.m + 5), (double)(this.n + 5)));
        for (int l = 0; l < list1.size(); ++l) {
            md victim = (md)list1.get(l);
            if (ItemArmorHazmat.hasCompleteHazmat(victim)) continue;
            shock = true;
            victim.a((lh)IC2DamageSource.electricity, damage);
            for (int i = 0; i < damage; ++i) {
                this.k.a("reddust", victim.t + (double)this.k.t.nextFloat(), victim.u + (double)(this.k.t.nextFloat() * 2.0f), victim.v + (double)this.k.t.nextFloat(), 0.0, 0.0, 1.0);
            }
        }
        return shock;
    }

    public boolean redstoned() {
        return this.k.B(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n);
    }

    public static int getCost() {
        return 400;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxEnergy + this.maxInput) {
            need = this.maxEnergy + this.maxInput - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }
}

