/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ISidedInventory,
ITankContainer {
    public int maxLava = 24000;

    public TileEntityGeoGenerator() {
        super(2, IC2.energyGeneratorGeo, IC2.energyGeneratorGeo);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] == null || this.maxLava - this.fuel < 1000) {
            return false;
        }
        if (this.inventory[1].c == up.ay.cj) {
            this.fuel += 1000;
            this.inventory[1].c = up.aw.cj;
            return true;
        }
        if (this.inventory[1].c == Ic2Items.lavaCell.c) {
            this.fuel += 1000;
            --this.inventory[1].a;
            if (this.inventory[1].a <= 0) {
                this.inventory[1] = null;
            }
            return true;
        }
        LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)this.inventory[1]);
        if (liquid != null && liquid.itemID == amq.G.cm) {
            this.fuel += 1000;
            if (this.inventory[1].b().s()) {
                this.inventory[1] = this.inventory[1].b().getContainerItemStack(this.inventory[1]);
            } else {
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean gainFuelSub(ur stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String b() {
        if (IC2.platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerBaseGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.generator.gui.GuiGeoGenerator";
    }

    @Override
    public void onBlockBreak(int a, int b) {
        LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidSpilledEvent(new LiquidStack(amq.G.cm, this.fuel), this.k, this.l, this.m, this.n));
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource.itemID != amq.G.cm) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, (this.maxLava - this.fuel) / 1);
        if (doFill) {
            this.fuel += toAdd / 1;
        }
        return toAdd;
    }

    public LiquidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(0, maxEmpty, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        return null;
    }

    public LiquidTank[] getTanks(ForgeDirection side) {
        LiquidTank tank = new LiquidTank(new LiquidStack(amq.G.cm, this.fuel * 1), this.maxLava * 1, (any)this);
        tank.setTankPressure(0);
        return new LiquidTank[]{tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return type != null && type.itemID == amq.G.cm ? this.getTanks(ForgeDirection.UNKNOWN)[0] : null;
    }
}

