/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.IWrenchable;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import java.util.List;
import java.util.Vector;

public class TileEntityBlock
extends any
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;

    public void s() {
        super.s();
        if (!this.loaded) {
            if (!this.r() && this.k != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.k, new ITickCallback(){

                        @Override
                        public void tickCallback(yc world) {
                            TileEntityBlock.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warning(this + " (" + this.l + "," + this.m + "," + this.n + ") was not added, isInvalid=" + this.r() + ", worldObj=" + this.k);
            }
        }
    }

    public void w_() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.w_();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        if (!IC2.platform.isSimulating()) {
            IC2.network.requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.d("facing");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            IC2.network.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int blockId = this.k.a(this.l, this.m, this.n);
            if (blockId < amq.p.length && amq.p[blockId] != null) {
                int side;
                amq block = amq.p[blockId];
                boolean newActive = this.active;
                short newFacing = this.facing;
                this.active = this.prevActive;
                this.facing = this.prevFacing;
                int[] textureIndex = new int[6];
                for (side = 0; side < 6; ++side) {
                    textureIndex[side] = IC2.platform.getBlockTexture(block, (ym)this.k, this.l, this.m, this.n, side);
                }
                this.active = newActive;
                this.facing = newFacing;
                for (side = 0; side < 6; ++side) {
                    int newTextureIndex = IC2.platform.getBlockTexture(block, (ym)this.k, this.l, this.m, this.n, side);
                    if (textureIndex[side] == newTextureIndex || IC2.textureIndex.get(blockId, textureIndex[side]) == IC2.textureIndex.get(blockId, newTextureIndex)) continue;
                    this.k.i(this.l, this.m, this.n);
                    break;
                }
            } else {
                System.out.println("[IC2] Invalid TE at " + this.l + "/" + this.m + "/" + this.n + ", no corresponding block");
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            IC2.network.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        return new ur(this.k.a(this.l, this.m, this.n), 1, this.k.h(this.l, this.m, this.n));
    }

    public void onBlockBreak(int a, int b) {
    }
}

