/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksContainerManager;
import invtweaks.InvTweaksContainerSectionManager;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.InvTweaksObfuscation;
import invtweaks.api.ContainerSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class InvTweaksHandlerSorting
extends InvTweaksObfuscation {
    private static final Logger log = InvTweaks.log;
    public static final boolean STACK_NOT_EMPTIED = true;
    public static final boolean STACK_EMPTIED = false;
    private static int[] DEFAULT_LOCK_PRIORITIES = null;
    private static boolean[] DEFAULT_FROZEN_SLOTS = null;
    private static final int MAX_CONTAINER_SIZE = 999;
    public static final int ALGORITHM_DEFAULT = 0;
    public static final int ALGORITHM_VERTICAL = 1;
    public static final int ALGORITHM_HORIZONTAL = 2;
    public static final int ALGORITHM_INVENTORY = 3;
    public static final int ALGORITHM_EVEN_STACKS = 4;
    private InvTweaksContainerSectionManager containerMgr;
    private int algorithm;
    private int size;
    private boolean sortArmorParts;
    private InvTweaksItemTree tree;
    private Vector rules;
    private int[] rulePriority;
    private int[] keywordOrder;
    private int[] lockPriorities;
    private boolean[] frozenSlots;

    public InvTweaksHandlerSorting(Minecraft minecraft, InvTweaksConfig invTweaksConfig, ContainerSection containerSection, int n, int n2) throws Exception {
        super(minecraft);
        int n3;
        if (DEFAULT_LOCK_PRIORITIES == null) {
            DEFAULT_LOCK_PRIORITIES = new int[999];
            for (n3 = 0; n3 < 999; ++n3) {
                InvTweaksHandlerSorting.DEFAULT_LOCK_PRIORITIES[n3] = 0;
            }
        }
        if (DEFAULT_FROZEN_SLOTS == null) {
            DEFAULT_FROZEN_SLOTS = new boolean[999];
            for (n3 = 0; n3 < 999; ++n3) {
                InvTweaksHandlerSorting.DEFAULT_FROZEN_SLOTS[n3] = false;
            }
        }
        this.containerMgr = new InvTweaksContainerSectionManager(minecraft, containerSection);
        this.size = this.containerMgr.getSize();
        this.sortArmorParts = invTweaksConfig.getProperty("enableAutoEquipArmor").equals("true") && !this.isGuiInventoryCreative(this.getCurrentScreen());
        this.rules = invTweaksConfig.getRules();
        this.tree = invTweaksConfig.getTree();
        if (containerSection == ContainerSection.INVENTORY) {
            this.lockPriorities = invTweaksConfig.getLockPriorities();
            this.frozenSlots = invTweaksConfig.getFrozenSlots();
            this.algorithm = 3;
        } else {
            this.lockPriorities = DEFAULT_LOCK_PRIORITIES;
            this.frozenSlots = DEFAULT_FROZEN_SLOTS;
            this.algorithm = n;
            if (n != 0) {
                this.computeLineSortingRules(n2, n == 2);
            }
        }
        this.rulePriority = new int[this.size];
        this.keywordOrder = new int[this.size];
        for (n3 = 0; n3 < this.size; ++n3) {
            this.rulePriority[n3] = -1;
            ItemStack itemStack = this.containerMgr.getItemStack(n3);
            this.keywordOrder[n3] = itemStack != null ? this.getItemOrder(itemStack) : -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sort() throws TimeoutException {
        int n;
        long l = System.nanoTime();
        InvTweaksContainerManager invTweaksContainerManager = new InvTweaksContainerManager(this.mc);
        if (this.getHeldStack() != null) {
            n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
            if (n != -1) {
                invTweaksContainerManager.putHoldItemDown(ContainerSection.INVENTORY, n);
            } else {
                return;
            }
        }
        if (this.algorithm != 0) {
            int n2;
            Object object;
            if (this.algorithm == 4) {
                List<Integer> list;
                log.info("Distributing items.");
                HashMap<List<Integer>, int[]> hashMap = new HashMap<List<Integer>, int[]>();
                for (int i = 0; i < this.size; ++i) {
                    ItemStack object22 = this.containerMgr.getItemStack(i);
                    if (object22 == null) continue;
                    list = Arrays.asList(this.getItemID(object22), this.getItemDamage(object22));
                    object = (int[])hashMap.get(list);
                    if (object == null) {
                        int[] nArray = new int[]{this.getStackSize(object22), 1};
                        hashMap.put(list, nArray);
                        continue;
                    }
                    object[0] = object[0] + this.getStackSize(object22);
                    object[1] = object[1] + 1;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n3;
                    list = (List<Integer>)entry.getKey();
                    object = (int[])entry.getValue();
                    int n4 = object[0] / object[1];
                    if (n4 > this.getMaxStackSize(new ItemStack(list.get(0).intValue(), 1, 0))) continue;
                    LinkedList<Integer> linkedList = new LinkedList<Integer>();
                    LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                    for (n3 = 0; n3 < this.size; ++n3) {
                        ItemStack itemStack = this.containerMgr.getItemStack(n3);
                        if (itemStack == null || !((Object)Arrays.asList(this.getItemID(itemStack), this.getItemDamage(itemStack))).equals(list)) continue;
                        n2 = this.getStackSize(itemStack);
                        if (n2 > n4) {
                            linkedList2.offer(n3);
                            continue;
                        }
                        if (n2 >= n4) continue;
                        linkedList.offer(n3);
                    }
                    while (!linkedList.isEmpty()) {
                        n3 = (Integer)linkedList2.peek();
                        int n5 = this.getStackSize(this.containerMgr.getItemStack(n3));
                        n2 = (Integer)linkedList.peek();
                        int n6 = this.getStackSize(this.containerMgr.getItemStack(n2));
                        this.containerMgr.moveSome(n3, n2, Math.min(n4 - n6, n5 - n4));
                        n5 = this.getStackSize(this.containerMgr.getItemStack(n3));
                        n6 = this.getStackSize(this.containerMgr.getItemStack(n2));
                        if (n5 == n4) {
                            linkedList2.remove();
                        }
                        if (n6 != n4) continue;
                        linkedList.remove();
                    }
                    while (linkedList2.size() > 1) {
                        n3 = (Integer)linkedList2.poll();
                        int n7 = this.getStackSize(this.containerMgr.getItemStack(n3));
                        this.containerMgr.moveSome(n3, (Integer)linkedList2.peek(), n7 - n4);
                    }
                }
                for (int i = 0; i < this.size; ++i) {
                    this.markAsMoved(i, 1);
                }
            } else if (this.algorithm == 3) {
                log.info("Handling crafting slots.");
                if (invTweaksContainerManager.hasSection(ContainerSection.CRAFTING_IN)) {
                    List list = invTweaksContainerManager.getSlots(ContainerSection.CRAFTING_IN);
                    int n8 = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
                    if (n8 != -1) {
                        for (Slot slot : list) {
                            if (!this.hasStack(slot)) continue;
                            invTweaksContainerManager.move(ContainerSection.CRAFTING_IN, invTweaksContainerManager.getSlotIndex(this.getSlotNumber(slot)), ContainerSection.INVENTORY, n8);
                            n8 = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
                            if (n8 != -1) continue;
                            break;
                        }
                    }
                }
                log.info("Merging stacks.");
                block7: for (n = this.size - 1; n >= 0; --n) {
                    void var10_36;
                    ItemStack itemStack;
                    ItemStack itemStack2 = this.containerMgr.getItemStack(n);
                    if (itemStack2 == null) continue;
                    Item item = this.getItem(itemStack2);
                    if (this.isDamageable(item)) {
                        if (!this.sortArmorParts || !this.isItemArmor(item)) continue;
                        ItemArmor itemArmor = this.asItemArmor(item);
                        if (!invTweaksContainerManager.hasSection(ContainerSection.ARMOR)) continue;
                        object = invTweaksContainerManager.getSlots(ContainerSection.ARMOR);
                        for (Slot slot : object) {
                            boolean bl = false;
                            if (!this.hasStack(slot)) {
                                bl = true;
                            } else {
                                itemStack = this.getItem(this.getStack(slot));
                                if (this.isItemArmor(itemStack)) {
                                    int n8 = this.getArmorLevel(this.asItemArmor((Item)itemStack));
                                    if (n8 < this.getArmorLevel(itemArmor) || n8 == this.getArmorLevel(itemArmor) && this.getItemDamage(this.getStack(slot)) < this.getItemDamage(itemStack2)) {
                                        bl = true;
                                    }
                                } else {
                                    bl = true;
                                }
                            }
                            if (!this.areSlotAndStackCompatible(slot, itemStack2) || !bl) continue;
                            invTweaksContainerManager.move(ContainerSection.INVENTORY, n, ContainerSection.ARMOR, invTweaksContainerManager.getSlotIndex(this.getSlotNumber(slot)));
                        }
                        continue;
                    }
                    int n9 = 0;
                    object = this.lockPriorities;
                    int n10 = ((int[])object).length;
                    boolean bl = false;
                    while (var10_36 < n10) {
                        Integer n11 = object[var10_36];
                        if (n11 > 0 && (itemStack = this.containerMgr.getItemStack(n9)) != null && this.areItemsEqual(itemStack2, itemStack)) {
                            this.move(n, n9, Integer.MAX_VALUE);
                            this.markAsNotMoved(n9);
                            if (this.containerMgr.getItemStack(n) == null) continue block7;
                        }
                        ++n9;
                        ++var10_36;
                    }
                }
            }
            log.info("Applying rules.");
            for (InvTweaksConfigSortingRule invTweaksConfigSortingRule : this.rules) {
                int n12 = invTweaksConfigSortingRule.getPriority();
                if (log.getLevel() == InvTweaksConst.DEBUG) {
                    log.info("Rule : " + invTweaksConfigSortingRule.getKeyword() + "(" + n12 + ")");
                }
                block11: for (int i = 0; i < this.size; ++i) {
                    List list;
                    object = this.containerMgr.getItemStack(i);
                    if (!this.hasToBeMoved(i) || this.lockPriorities[i] >= n12 || !this.tree.matches(list = this.tree.getItems(this.getItemID((ItemStack)object), this.getItemDamage((ItemStack)object)), invTweaksConfigSortingRule.getKeyword())) continue;
                    int[] nArray = invTweaksConfigSortingRule.getPreferredSlots();
                    int n13 = i;
                    for (int j = 0; j < nArray.length; ++j) {
                        int n14 = nArray[j];
                        n2 = this.move(n13, n14, n12);
                        if (n2 == -1) continue;
                        if (n2 == n14 || !this.tree.matches(list = this.tree.getItems(this.getItemID((ItemStack)(object = this.containerMgr.getItemStack(n2))), this.getItemDamage((ItemStack)object)), invTweaksConfigSortingRule.getKeyword())) continue block11;
                        n13 = n2;
                        j = -1;
                    }
                }
            }
            log.info("Locking stacks.");
            for (int i = 0; i < this.size; ++i) {
                if (!this.hasToBeMoved(i) || this.lockPriorities[i] <= 0) continue;
                this.markAsMoved(i, 1);
            }
        }
        this.defaultSorting();
        if (log.getLevel() == InvTweaksConst.DEBUG) {
            l = System.nanoTime() - l;
            log.info("Sorting done in " + l + "ns");
        }
        if (this.getHeldStack() != null && (n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY)) != -1) {
            invTweaksContainerManager.putHoldItemDown(ContainerSection.INVENTORY, n);
        }
    }

    private void defaultSorting() throws TimeoutException {
        int n;
        log.info("Default sorting.");
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < this.size; ++n) {
            if (!this.hasToBeMoved(n)) continue;
            vector.add(n);
            vector2.add(n);
        }
        n = 0;
        while (vector.size() > 0 && n++ < 50) {
            Iterator iterator = vector.iterator();
            block2: while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (this.hasToBeMoved(n2)) {
                    for (int i = 0; i < this.size; ++i) {
                        if (this.move(n2, i, 1) == -1) continue;
                        vector2.remove((Object)i);
                        continue block2;
                    }
                    continue;
                }
                vector2.remove((Object)n2);
            }
            vector.clear();
            vector.addAll(vector2);
        }
        if (n == 100) {
            log.warning("Sorting takes too long, aborting.");
        }
    }

    private int move(int n, int n2, int n3) throws TimeoutException {
        ItemStack itemStack = this.containerMgr.getItemStack(n);
        ItemStack itemStack2 = this.containerMgr.getItemStack(n2);
        if (itemStack == null || this.frozenSlots[n2] || this.frozenSlots[n]) {
            return -1;
        }
        if (this.lockPriorities[n] <= n3) {
            if (n == n2) {
                this.markAsMoved(n, n3);
                return n2;
            }
            if (itemStack2 == null && this.lockPriorities[n2] <= n3 && !this.frozenSlots[n2]) {
                this.rulePriority[n] = -1;
                this.keywordOrder[n] = -1;
                this.rulePriority[n2] = n3;
                this.keywordOrder[n2] = this.getItemOrder(itemStack);
                this.containerMgr.move(n, n2);
                return n2;
            }
            if (itemStack2 != null) {
                boolean bl = false;
                if (this.lockPriorities[n2] <= n3) {
                    if (this.rulePriority[n2] < n3) {
                        bl = true;
                    } else if (this.rulePriority[n2] == n3 && this.isOrderedBefore(n, n2)) {
                        bl = true;
                    }
                }
                if (!this.hasDataTags(itemStack) && !this.hasDataTags(itemStack2) && this.areItemsEqual(itemStack, itemStack2)) {
                    if (this.getStackSize(itemStack2) < this.getMaxStackSize(itemStack2)) {
                        bl = true;
                    } else if (this.getStackSize(itemStack) > this.getMaxStackSize(itemStack)) {
                        bl = false;
                    }
                }
                if (bl) {
                    this.keywordOrder[n2] = this.keywordOrder[n];
                    this.rulePriority[n2] = n3;
                    this.rulePriority[n] = -1;
                    this.containerMgr.move(n, n2);
                    ItemStack itemStack3 = this.containerMgr.getItemStack(n);
                    if (itemStack3 != null) {
                        int n4 = n;
                        if (this.lockPriorities[n2] > this.lockPriorities[n]) {
                            for (int i = 0; i < this.size; ++i) {
                                if (this.containerMgr.getItemStack(i) != null || this.lockPriorities[i] != 0) continue;
                                n4 = i;
                                break;
                            }
                        }
                        if (n4 != n) {
                            this.containerMgr.move(n, n4);
                        }
                        this.rulePriority[n4] = -1;
                        this.keywordOrder[n4] = this.getItemOrder(itemStack3);
                        return n4;
                    }
                    return n2;
                }
            }
        }
        return -1;
    }

    private void markAsMoved(int n, int n2) {
        this.rulePriority[n] = n2;
    }

    private void markAsNotMoved(int n) {
        this.rulePriority[n] = -1;
    }

    private boolean hasToBeMoved(int n) {
        return this.containerMgr.getItemStack(n) != null && this.rulePriority[n] == -1;
    }

    private boolean isOrderedBefore(int n, int n2) {
        ItemStack itemStack = this.containerMgr.getItemStack(n);
        ItemStack itemStack2 = this.containerMgr.getItemStack(n2);
        if (itemStack2 == null) {
            return true;
        }
        if (itemStack == null || this.keywordOrder[n] == -1) {
            return false;
        }
        if (this.keywordOrder[n] == this.keywordOrder[n2]) {
            if (this.getItemID(itemStack) == this.getItemID(itemStack2)) {
                if (this.getItemDamage(itemStack) != this.getItemDamage(itemStack2)) {
                    if (this.isItemStackDamageable(itemStack)) {
                        return this.getItemDamage(itemStack) > this.getItemDamage(itemStack2);
                    }
                    return this.getItemDamage(itemStack) < this.getItemDamage(itemStack2);
                }
                return this.getStackSize(itemStack) > this.getStackSize(itemStack2);
            }
            return this.getItemID(itemStack) > this.getItemID(itemStack2);
        }
        return this.keywordOrder[n] < this.keywordOrder[n2];
    }

    private int getItemOrder(ItemStack itemStack) {
        List list = this.tree.getItems(this.getItemID(itemStack), this.getItemDamage(itemStack));
        return list != null && list.size() > 0 ? ((InvTweaksItemTreeItem)list.get(0)).getOrder() : Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private void computeLineSortingRules(int n, boolean bl) {
        void var18_25;
        int n2;
        int n3;
        this.rules = new Vector();
        Map map = this.computeContainerStats();
        ArrayList<InvTweaksItemTreeItem> arrayList = new ArrayList<InvTweaksItemTreeItem>();
        int n4 = map.size();
        int n5 = this.getContainerColumnSize(n);
        int n6 = this.size;
        int n7 = 0;
        for (Integer n8 : map.values()) {
            n7 += n8.intValue();
        }
        if (n4 == 0) {
            return;
        }
        ArrayList arrayList2 = new ArrayList(map.keySet());
        boolean bl2 = true;
        block1: while (bl2) {
            bl2 = false;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                InvTweaksItemTreeItem invTweaksItemTreeItem = (InvTweaksItemTreeItem)iterator.next();
                Integer n9 = (Integer)map.get(invTweaksItemTreeItem);
                if (n9 <= (bl ? n : n5) || arrayList.contains(invTweaksItemTreeItem)) continue;
                bl2 = true;
                arrayList.add(invTweaksItemTreeItem);
                arrayList2.remove(invTweaksItemTreeItem);
                continue block1;
            }
        }
        Collections.sort(arrayList2, Collections.reverseOrder());
        arrayList.addAll(arrayList2);
        if (bl) {
            n3 = 1;
            n2 = n / ((n4 + n5 - 1) / n5);
        } else {
            n2 = 1;
            n3 = n5 / ((n4 + n - 1) / n);
        }
        char c = 'a';
        char c2 = (char)(c - 1 + n5);
        char c3 = '1';
        char c4 = (char)(c3 - 1 + n);
        for (InvTweaksItemTreeItem object2 : arrayList) {
            int n8 = n2;
            int n9 = n3;
            while ((Integer)map.get(object2) > n9 * n8) {
                if (bl) {
                    if (c3 + n8 < c4) {
                        n8 = c4 - c3 + 1;
                        continue;
                    }
                    if (c + n9 >= c2) break;
                    ++n9;
                    continue;
                }
                if (c + n9 < c2) {
                    n9 = c2 - c + 1;
                    continue;
                }
                if (c3 + n8 >= c4) break;
                ++n8;
            }
            if (bl && c3 + n8 == c4) {
                ++n8;
            } else if (!bl && c + n9 == c2) {
                ++n9;
            }
            String string = c + "" + c3 + "-" + (char)(c - '\u0001' + n9) + (char)(c3 - '\u0001' + n8);
            if (!bl) {
                string = string + 'v';
            }
            this.rules.add(new InvTweaksConfigSortingRule(this.tree, string, object2.getName(), this.size, n));
            if ((n6 -= n9 * n8) < (n7 -= ((Integer)map.get(object2)).intValue())) break;
            if (bl) {
                if (c3 + n8 + n2 <= c4 + '\u0001') {
                    c3 = (char)(c3 + n8);
                } else {
                    c3 = '1';
                    c = (char)(c + n9);
                }
            } else if (c + n9 + n3 <= c2 + '\u0001') {
                c = (char)(c + n9);
            } else {
                c = 'a';
                c3 = (char)(c3 + n8);
            }
            if (c <= c2 && c3 <= c4) continue;
            break;
        }
        if (bl) {
            String string = c2 + "1-a" + c4;
        } else {
            String string = "a" + c4 + "-" + c2 + "1v";
        }
        this.rules.add(new InvTweaksConfigSortingRule(this.tree, (String)var18_25, this.tree.getRootCategory().getName(), this.size, n));
    }

    private Map computeContainerStats() {
        HashMap<InvTweaksItemTreeItem, Integer> hashMap = new HashMap<InvTweaksItemTreeItem, Integer>();
        HashMap<Integer, InvTweaksItemTreeItem> hashMap2 = new HashMap<Integer, InvTweaksItemTreeItem>();
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack = this.containerMgr.getItemStack(i);
            if (itemStack == null) continue;
            int n = this.getItemID(itemStack) * 100000 + (this.getMaxStackSize(itemStack) != 1 ? this.getItemDamage(itemStack) : 0);
            InvTweaksItemTreeItem invTweaksItemTreeItem = (InvTweaksItemTreeItem)hashMap2.get(n);
            if (invTweaksItemTreeItem == null) {
                invTweaksItemTreeItem = (InvTweaksItemTreeItem)this.tree.getItems(this.getItemID(itemStack), this.getItemDamage(itemStack)).get(0);
                hashMap2.put(n, invTweaksItemTreeItem);
                hashMap.put(invTweaksItemTreeItem, 1);
                continue;
            }
            hashMap.put(invTweaksItemTreeItem, (Integer)hashMap.get(invTweaksItemTreeItem) + 1);
        }
        return hashMap;
    }

    private int getContainerColumnSize(int n) {
        return this.size / n;
    }
}

