/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfigSortingRuleType;
import invtweaks.InvTweaksItemTree;
import java.awt.Point;
import java.util.logging.Logger;

public class InvTweaksConfigSortingRule
implements Comparable {
    private static final Logger log = InvTweaks.log;
    private String constraint;
    private int[] preferredPositions;
    private String keyword;
    private InvTweaksConfigSortingRuleType type;
    private int priority;
    private int containerSize;
    private int containerRowSize;

    public InvTweaksConfigSortingRule(InvTweaksItemTree invTweaksItemTree, String string, String string2, int n, int n2) {
        this.keyword = string2;
        this.constraint = string;
        this.containerSize = n;
        this.containerRowSize = n2;
        this.type = InvTweaksConfigSortingRule.getRuleType(string, n2);
        this.preferredPositions = this.getRulePreferredPositions(string);
        this.priority = this.type.getLowestPriority() + 100000 + invTweaksItemTree.getKeywordDepth(string2) * 1000 - invTweaksItemTree.getKeywordOrder(string2);
    }

    public InvTweaksConfigSortingRuleType getType() {
        return this.type;
    }

    public int[] getPreferredSlots() {
        return this.preferredPositions;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getRawConstraint() {
        return this.constraint;
    }

    public int getPriority() {
        return this.priority;
    }

    public int compareTo(InvTweaksConfigSortingRule invTweaksConfigSortingRule) {
        return this.getPriority() - invTweaksConfigSortingRule.getPriority();
    }

    public int[] getRulePreferredPositions(String string) {
        return InvTweaksConfigSortingRule.getRulePreferredPositions(string, this.containerSize, this.containerRowSize);
    }

    public static int[] getRulePreferredPositions(String string, int n, int n2) {
        int[] nArray;
        block15: {
            int n3;
            int n4;
            block14: {
                String[] stringArray;
                nArray = null;
                n4 = n / n2;
                if (string.length() < 5) break block14;
                boolean bl = false;
                if (string.contains("v")) {
                    bl = true;
                    string = string.replaceAll("v", "");
                }
                if ((stringArray = string.split("-")).length != 2) break block15;
                int[] nArray2 = InvTweaksConfigSortingRule.getRulePreferredPositions(stringArray[0], n, n2);
                int[] nArray3 = InvTweaksConfigSortingRule.getRulePreferredPositions(stringArray[1], n, n2);
                if (nArray2.length != 1 || nArray3.length != 1) break block15;
                int n5 = nArray2[0];
                int n6 = nArray3[0];
                Point point = new Point(n5 % n2, n5 / n2);
                Point point2 = new Point(n6 % n2, n6 / n2);
                nArray = new int[(Math.abs(point2.y - point.y) + 1) * (Math.abs(point2.x - point.x) + 1)];
                int n7 = 0;
                if (bl) {
                    for (Point point3 : new Point[]{point, point2}) {
                        int n8 = point3.x;
                        point3.x = point3.y;
                        point3.y = n8;
                    }
                }
                int n9 = point.y;
                while (point.y < point2.y ? n9 <= point2.y : n9 >= point2.y) {
                    int n10 = point.x;
                    while (point.x < point2.x ? n10 <= point2.x : n10 >= point2.x) {
                        nArray[n7++] = bl ? InvTweaksConfigSortingRule.index(n2, n10, n9) : InvTweaksConfigSortingRule.index(n2, n9, n10);
                        n10 += point.x < point2.x ? 1 : -1;
                    }
                    n9 += point.y < point2.y ? 1 : -1;
                }
                if (!string.contains("r")) break block15;
                InvTweaksConfigSortingRule.reverseArray(nArray);
                break block15;
            }
            int n11 = -1;
            int n12 = -1;
            boolean bl = false;
            for (n3 = 0; n3 < string.length(); ++n3) {
                char c = string.charAt(n3);
                if (c >= '1' && c - 49 <= n2) {
                    n11 = c - 49;
                    continue;
                }
                if (c >= 'a' && c - 97 <= n4) {
                    n12 = c - 97;
                    continue;
                }
                if (c != 'r') continue;
                bl = true;
            }
            if (n11 != -1 && n12 != -1) {
                nArray = new int[]{InvTweaksConfigSortingRule.index(n2, n12, n11)};
            } else if (n12 != -1) {
                nArray = new int[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    nArray[n3] = InvTweaksConfigSortingRule.index(n2, n12, bl ? n2 - 1 - n3 : n3);
                }
            } else {
                nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray[n3] = InvTweaksConfigSortingRule.index(n2, bl ? n3 : n4 - 1 - n3, n11);
                }
            }
        }
        return nArray;
    }

    public static InvTweaksConfigSortingRuleType getRuleType(String string, int n) {
        InvTweaksConfigSortingRuleType invTweaksConfigSortingRuleType = InvTweaksConfigSortingRuleType.SLOT;
        if (string.length() == 1 || string.length() == 2 && string.contains("r")) {
            invTweaksConfigSortingRuleType = (string = string.replace("r", "")).charAt(0) - 49 <= n && string.charAt(0) >= '1' ? InvTweaksConfigSortingRuleType.COLUMN : InvTweaksConfigSortingRuleType.ROW;
        } else if (string.length() > 4) {
            invTweaksConfigSortingRuleType = string.charAt(1) == string.charAt(4) ? InvTweaksConfigSortingRuleType.COLUMN : (string.charAt(0) == string.charAt(3) ? InvTweaksConfigSortingRuleType.ROW : InvTweaksConfigSortingRuleType.RECTANGLE);
        }
        return invTweaksConfigSortingRuleType;
    }

    public String toString() {
        return this.constraint + " " + this.keyword;
    }

    private static int index(int n, int n2, int n3) {
        return n2 * n + n3;
    }

    private static void reverseArray(int[] nArray) {
        int n = 0;
        for (int i = nArray.length - 1; n < i; ++n, --i) {
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
    }
}

