/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksItemTree;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksConfigInventoryRuleset {
    private static final Logger log = InvTweaks.log;
    private String name;
    private int[] lockPriorities;
    private boolean[] frozenSlots;
    private Vector lockedSlots;
    private Vector rules;
    private Vector autoReplaceRules;
    private boolean debugEnabled;
    private InvTweaksItemTree tree;

    public InvTweaksConfigInventoryRuleset(InvTweaksItemTree invTweaksItemTree, String string) {
        int n;
        this.tree = invTweaksItemTree;
        this.name = string.trim();
        this.lockPriorities = new int[36];
        for (n = 0; n < this.lockPriorities.length; ++n) {
            this.lockPriorities[n] = 0;
        }
        this.frozenSlots = new boolean[36];
        for (n = 0; n < this.frozenSlots.length; ++n) {
            this.frozenSlots[n] = false;
        }
        this.lockedSlots = new Vector();
        this.rules = new Vector();
        this.autoReplaceRules = new Vector();
        this.debugEnabled = false;
    }

    public String registerLine(String string) throws InvalidParameterException {
        InvTweaksConfigSortingRule invTweaksConfigSortingRule = null;
        String string2 = string.replaceAll("[\\s]+", " ").toLowerCase();
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 2) {
            if (string2.matches("^([a-d]|[1-9]|[r]){1,2} [\\w]*$") || string2.matches("^[a-d][1-9]-[a-d][1-9][rv]?[rv]? [\\w]*$")) {
                stringArray[0] = stringArray[0].toLowerCase();
                stringArray[1] = stringArray[1];
                if (stringArray[1].equals("locked")) {
                    int[] nArray = InvTweaksConfigSortingRule.getRulePreferredPositions(stringArray[0], 36, 9);
                    int n = InvTweaksConfigSortingRule.getRuleType(stringArray[0], 9).getLowestPriority() - 1;
                    for (int n2 : nArray) {
                        this.lockPriorities[n2] = n;
                    }
                    return null;
                }
                if (stringArray[1].equals("frozen")) {
                    int[] nArray;
                    for (int n : nArray = InvTweaksConfigSortingRule.getRulePreferredPositions(stringArray[0], 36, 9)) {
                        this.frozenSlots[n] = true;
                    }
                    return null;
                }
                String string3 = stringArray[1].toLowerCase();
                boolean bl = this.tree.isKeywordValid(string3);
                if (!bl) {
                    if (string3.matches("^[0-9-]*$")) {
                        bl = true;
                    } else {
                        Vector vector = this.getKeywordVariants(string3);
                        for (String string4 : vector) {
                            if (!this.tree.isKeywordValid(string4.toLowerCase())) continue;
                            bl = true;
                            string3 = string4;
                            break;
                        }
                    }
                }
                if (bl) {
                    invTweaksConfigSortingRule = new InvTweaksConfigSortingRule(this.tree, stringArray[0], string3.toLowerCase(), 36, 9);
                    this.rules.add(invTweaksConfigSortingRule);
                    return null;
                }
                return string3.toLowerCase();
            }
            if (stringArray[0].equals("autorefill") || stringArray[0].equals("autoreplace")) {
                stringArray[1] = stringArray[1].toLowerCase();
                if (this.tree.isKeywordValid(stringArray[1]) || stringArray[1].equals("nothing")) {
                    this.autoReplaceRules.add(stringArray[1]);
                }
                return null;
            }
        } else if (stringArray.length == 1 && stringArray[0].equals("debug")) {
            this.debugEnabled = true;
            return null;
        }
        throw new InvalidParameterException();
    }

    public void finalize() {
        if (this.autoReplaceRules.isEmpty()) {
            try {
                this.autoReplaceRules.add(this.tree.getRootCategory().getName());
            }
            catch (NullPointerException nullPointerException) {
                throw new NullPointerException("No root category is defined.");
            }
        }
        Collections.sort(this.rules, Collections.reverseOrder());
        for (int i = 0; i < this.lockPriorities.length; ++i) {
            if (this.lockPriorities[i] <= 0) continue;
            this.lockedSlots.add(i);
        }
    }

    public String getName() {
        return this.name;
    }

    public int[] getLockPriorities() {
        return this.lockPriorities;
    }

    public boolean[] getFrozenSlots() {
        return this.frozenSlots;
    }

    public Vector getLockedSlots() {
        return this.lockedSlots;
    }

    public Vector getRules() {
        return this.rules;
    }

    public Vector getAutoReplaceRules() {
        return this.autoReplaceRules;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    private Vector getKeywordVariants(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.endsWith("es")) {
            vector.add(string.substring(0, string.length() - 2));
        }
        if (string.endsWith("s")) {
            vector.add(string.substring(0, string.length() - 1));
        }
        if (string.contains("en")) {
            vector.add(string.replaceAll("en", ""));
        } else {
            if (string.contains("wood")) {
                vector.add(string.replaceAll("wood", "wooden"));
            }
            if (string.contains("gold")) {
                vector.add(string.replaceAll("gold", "golden"));
            }
        }
        if (string.matches("\\w*[A-Z]\\w*")) {
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 65 || byArray[i] > 90) continue;
                String string2 = (string.substring(i) + string.substring(0, i)).toLowerCase();
                vector.add(string2);
                vector.addAll(this.getKeywordVariants(string2));
            }
        }
        return vector;
    }
}

