/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_thePlayer", name="Dynamic Lights Player Light", version="1.0.4", dependencies="required-after:DynamicLights")
public class PlayerSelfLightSource
implements IDynamicLightSource {
    private sq thePlayer;
    private aab lastWorld;
    private int lightLevel;
    private boolean enabled;
    private HashMap itemsMap;
    private HashSet notWaterProofItems;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        String[] tokens;
        this.itemsMap = new HashMap();
        this.notWaterProofItems = new HashSet();
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property itemsList = config.get("general", "LightItems", "50:15,89:12,348:10,91:15,327:15,76:10,331:10,314:14");
        itemsList.comment = "Item IDs that shine light while held. Armor Items also work when worn. [ONLY ON YOURSELF] Syntax: ItemID:LightValue, seperated by commas";
        for (String pair : tokens = itemsList.getString().split(",")) {
            String[] values = pair.split(":");
            int id = Integer.valueOf(values[0]);
            int value = Integer.valueOf(values[1]);
            this.itemsMap.put(id, value);
        }
        Property notWaterProofList = config.get("general", "TurnedOffByWaterItems", "50,327");
        notWaterProofList.comment = "Item IDs that do not shine light when held in water, have to be present in LightItems. Syntax: ItemID, seperated by commas";
        for (String oneId : tokens = notWaterProofList.getString().split(",")) {
            this.notWaterProofItems.add(Integer.valueOf(oneId));
        }
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.lightLevel = 0;
        this.enabled = false;
        this.lastWorld = null;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getLightFromItemStack(wm stack) {
        Integer i;
        if (stack != null && (i = (Integer)this.itemsMap.get(stack.c)) != null) {
            return i;
        }
        return 0;
    }

    private void enableLight() {
        DynamicLights.addLightSource(this);
        this.enabled = true;
    }

    private void disableLight() {
        DynamicLights.removeLightSource(this);
        this.enabled = false;
    }

    @Override
    public mp getAttachmentEntity() {
        return this.thePlayer;
    }

    @Override
    public int getLightLevel() {
        return this.lightLevel;
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (PlayerSelfLightSource.this.lastWorld != FMLClientHandler.instance().getClient().e || PlayerSelfLightSource.this.thePlayer != FMLClientHandler.instance().getClient().g) {
                PlayerSelfLightSource.this.thePlayer = (sq)FMLClientHandler.instance().getClient().g;
                if (PlayerSelfLightSource.this.thePlayer != null) {
                    PlayerSelfLightSource.this.lastWorld = ((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.q;
                } else {
                    PlayerSelfLightSource.this.lastWorld = null;
                }
            }
            if (PlayerSelfLightSource.this.thePlayer != null && PlayerSelfLightSource.this.thePlayer.R() && !DynamicLights.globalLightsOff()) {
                int prevLight = PlayerSelfLightSource.this.lightLevel;
                PlayerSelfLightSource.this.lightLevel = PlayerSelfLightSource.this.getLightFromItemStack(PlayerSelfLightSource.this.thePlayer.cb());
                for (wm armor : ((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.bK.b) {
                    PlayerSelfLightSource.this.lightLevel = Math.max(PlayerSelfLightSource.this.lightLevel, PlayerSelfLightSource.this.getLightFromItemStack(armor));
                }
                if (prevLight != 0 && PlayerSelfLightSource.this.lightLevel != prevLight) {
                    PlayerSelfLightSource.this.lightLevel = 0;
                } else if (PlayerSelfLightSource.this.thePlayer.ae()) {
                    PlayerSelfLightSource.this.lightLevel = 15;
                } else if (PlayerSelfLightSource.this.thePlayer.G() && PlayerSelfLightSource.this.thePlayer.cb() != null && PlayerSelfLightSource.this.notWaterProofItems.contains(((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.cb().c)) {
                    PlayerSelfLightSource.this.lightLevel = 0;
                }
                if (!PlayerSelfLightSource.this.enabled && PlayerSelfLightSource.this.lightLevel > 8) {
                    PlayerSelfLightSource.this.enableLight();
                } else if (PlayerSelfLightSource.this.enabled && PlayerSelfLightSource.this.lightLevel < 9) {
                    PlayerSelfLightSource.this.disableLight();
                }
            }
        }

        public EnumSet ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_thePlayer";
        }
    }
}

