/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import reifnsk.minimap.GLTextureBufferedImage;

public class GLTexture {
    private static String DEFAULT_PACK;
    private static String pack;
    private static ArrayList list;
    private static GLTexture missing;
    static final GLTexture TEMPERATURE;
    static final GLTexture HUMIDITY;
    static final GLTexture ROUND_MAP;
    static final GLTexture ROUND_MAP_MASK;
    static final GLTexture SQUARE_MAP;
    static final GLTexture SQUARE_MAP_MASK;
    static final GLTexture ENTITY;
    static final GLTexture ENTITY2;
    static final GLTexture LIGHTNING;
    static final GLTexture N;
    static final GLTexture E;
    static final GLTexture W;
    static final GLTexture S;
    static final GLTexture MMARROW;
    static final GLTexture WAYPOINT1;
    static final GLTexture WAYPOINT2;
    static final GLTexture MARKER1;
    static final GLTexture MARKER2;
    private final String fileName;
    private final boolean blur;
    private final boolean clamp;
    private int textureId;

    static void setPack(String var0) {
        if (!var0.equals(pack)) {
            for (GLTexture var2 : list) {
                var2.release();
            }
            pack = var0;
        }
    }

    private GLTexture(String var1, boolean var2, boolean var3) {
        this.fileName = var1;
        this.blur = var2;
        this.clamp = var3;
        list.add(this);
    }

    int[] getData() {
        BufferedImage var1 = GLTexture.read(this.fileName);
        int var2 = var1.getWidth();
        int var3 = var1.getHeight();
        int[] var4 = new int[var2 * var3];
        var1.getRGB(0, 0, var2, var3, var4, 0, var2);
        return var4;
    }

    void bind() {
        if (this.textureId == 0) {
            BufferedImage var1 = GLTexture.read(this.fileName);
            if (var1 == null) {
                this.textureId = this == missing ? -2 : -1;
            } else {
                this.textureId = GL11.glGenTextures();
                int var2 = var1.getWidth();
                int var3 = var1.getHeight();
                int[] var4 = new int[var2 * var3];
                var1.getRGB(0, 0, var2, var3, var4, 0, var2);
                GLTextureBufferedImage.createTexture(var4, var2, var3, this.textureId, this.blur, this.clamp);
            }
        }
        if (this.textureId == -2) {
            GL11.glBindTexture((int)3553, (int)0);
        } else {
            if (this.textureId == -1) {
                missing.bind();
            }
            GL11.glBindTexture((int)3553, (int)this.textureId);
        }
    }

    void release() {
        if (this.textureId > 0) {
            GL11.glDeleteTextures((int)this.textureId);
        }
        this.textureId = 0;
    }

    private static BufferedImage read(String var0) {
        BufferedImage var1 = GLTexture.readImage(pack + var0);
        return var1 == null ? GLTexture.readImage(DEFAULT_PACK + var0) : var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(String var0) {
        Object var3;
        InputStream var1 = GLTexture.class.getResourceAsStream(var0);
        if (var1 == null) {
            return null;
        }
        try {
            BufferedImage var2;
            BufferedImage bufferedImage = var2 = ImageIO.read(var1);
            return bufferedImage;
        }
        catch (Exception var13) {
            var3 = null;
        }
        finally {
            try {
                var1.close();
            }
            catch (Exception exception) {}
        }
        return var3;
    }

    static {
        pack = DEFAULT_PACK = "/reifnsk/minimap/";
        list = new ArrayList();
        missing = new GLTexture("missing.png", true, false);
        TEMPERATURE = new GLTexture("temperature.png", true, true);
        HUMIDITY = new GLTexture("humidity.png", true, true);
        ROUND_MAP = new GLTexture("roundmap.png", true, true);
        ROUND_MAP_MASK = new GLTexture("roundmap_mask.png", false, true);
        SQUARE_MAP = new GLTexture("squaremap.png", true, true);
        SQUARE_MAP_MASK = new GLTexture("squaremap_mask.png", false, true);
        ENTITY = new GLTexture("entity.png", true, true);
        ENTITY2 = new GLTexture("entity2.png", true, true);
        LIGHTNING = new GLTexture("lightning.png", true, true);
        N = new GLTexture("n.png", true, true);
        E = new GLTexture("e.png", true, true);
        W = new GLTexture("w.png", true, true);
        S = new GLTexture("s.png", true, true);
        MMARROW = new GLTexture("mmarrow.png", true, true);
        WAYPOINT1 = new GLTexture("waypoint.png", true, true);
        WAYPOINT2 = new GLTexture("waypoint2.png", true, true);
        MARKER1 = new GLTexture("marker.png", true, true);
        MARKER2 = new GLTexture("marker2.png", true, true);
    }
}

