/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import reifnsk.minimap.ICustomChunk;
import reifnsk.minimap.ReiMinimap;

public class ChunkData {
    private static final int CHUNK_RELOAD_INTERVAL = 60;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int CHUNK_ARRAY_SIZE = 1024;
    private static final int CHUNK_SHIFT = 5;
    public final int xPosition;
    public final int zPosition;
    private abq chunk;
    private boolean chunkFileExist = true;
    private boolean chunkModified;
    private int chunkUpdateCount;
    private boolean chunkUpdate;
    private int lastRenderCount = reimm.getUpdateCount();
    private int lastAccessCount = reimm.getUpdateCount();
    private int lastUpdateCount = reimm.getUpdateCount();
    private int chunkReloadCount = reimm.getUpdateCount();
    int[] foliageColors = new int[256];
    int[] grassColors = new int[256];
    int[] waterColors = new int[256];
    int[] smoothFoliageColors = new int[256];
    int[] smoothGrassColors = new int[256];
    int[] smoothWaterColors = new int[256];
    float[] heightValues = new float[256];
    aap[] biomes = PLAINS;
    boolean enviromnentColorUpdateReq;
    boolean slime;
    private static aap[] PLAINS = new aap[256];
    private static final ReiMinimap reimm;
    private static final ChunkData[] cache;
    private static Minecraft minecraft;
    private static zv world;
    private static ach worldProvider;
    private static aau worldChunkManager;
    private static abn chunkProvider;
    private static abv chunkLoader;
    private static long seed;

    private ChunkData(int var1, int var2) {
        this.xPosition = var1;
        this.zPosition = var2;
        this.slime = seed != 0L && new Random(seed + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }

    public final boolean isAtLocation(int var1, int var2) {
        return var1 == this.xPosition && var2 == this.zPosition;
    }

    boolean updateChunk(boolean var1) {
        boolean var2 = false;
        int var3 = reimm.getUpdateCount();
        abv var4 = var1 ? chunkLoader : null;
        abq var5 = this.chunk;
        if (this.chunkReloadCount - var3 <= 0) {
            this.chunkReloadCount = var3 + 60;
            if (chunkProvider.a(this.xPosition, this.zPosition)) {
                this.chunk = chunkProvider.d(this.xPosition, this.zPosition);
                this.chunkFileExist = true;
            } else if (this.chunk == null && var4 != null && this.chunkFileExist) {
                try {
                    this.chunk = var4.a(world, this.xPosition, this.zPosition);
                }
                catch (IOException var7) {
                    var7.printStackTrace();
                }
                this.chunkFileExist = this.chunk != null;
                var2 = true;
            } else {
                this.chunkReloadCount = var3 + 7;
            }
        }
        if (this.chunk == null) {
            this.chunk = var5;
        }
        if (this.chunk != var5 || this.enviromnentColorUpdateReq) {
            this.updateEnvironmentColor();
            this.chunkUpdate = true;
        }
        if (this.chunk != null) {
            if (this.chunk instanceof ICustomChunk) {
                ICustomChunk var6 = (ICustomChunk)((Object)this.chunk);
                if (this.chunkUpdateCount != var6.updateCount()) {
                    this.chunkUpdateCount = var6.updateCount();
                    this.chunkUpdate = true;
                }
            } else if (this.chunkModified != this.chunk.l || this.chunkModified && var3 - this.lastUpdateCount >= 10) {
                this.chunkModified = this.chunk.l;
                this.chunkUpdate = true;
            }
        }
        return var2;
    }

    public abq getChunk() {
        return this.chunk;
    }

    private void updateEnvironmentColor() {
        int var5;
        int var2;
        if (this.chunk != null) {
            byte[] var1 = this.chunk.m();
            this.biomes = Arrays.copyOf(this.biomes, 256);
            for (var2 = 0; var2 < 256; ++var2) {
                int var3 = var1[var2] & 0xFF;
                if (var3 == 255) {
                    this.enviromnentColorUpdateReq = true;
                    return;
                }
                aap var4 = aap.a[var3];
                this.biomes[var2] = var4 == null ? aap.c : var4;
            }
        }
        this.enviromnentColorUpdateReq = false;
        for (var5 = 0; var5 < 256; ++var5) {
            aap var6 = this.biomes[var5];
            this.waterColors[var5] = var6.H;
            this.foliageColors[var5] = var6.l();
            this.grassColors[var5] = var6.k();
        }
        for (var5 = -1; var5 <= 16; ++var5) {
            for (var2 = -1; var2 <= 16; ++var2) {
                this.calcSmoothColor(var2, var5);
            }
        }
    }

    private void calcSmoothColor(int var1, int var2) {
        int var3 = var1 & 0xF | (var2 & 0xF) << 4;
        ChunkData var4 = ChunkData.getChunkData((var1 += this.xPosition << 4) >> 4, (var2 += this.zPosition << 4) >> 4);
        if (var4 != null) {
            int var5 = 0;
            int var6 = 0;
            int var7 = 0;
            int var8 = 0;
            int var9 = 0;
            int var10 = 0;
            int var11 = 0;
            int var12 = 0;
            int var13 = 0;
            int var14 = 0;
            for (int var15 = var2 - 1; var15 <= var2 + 1; ++var15) {
                for (int var16 = var1 - 1; var16 <= var1 + 1; ++var16) {
                    ChunkData var17 = ChunkData.getChunkData(var16 >> 4, var15 >> 4);
                    if (var17 == null || var17.biomes == null) continue;
                    int var18 = var16 & 0xF | (var15 & 0xF) << 4;
                    int var19 = var17.foliageColors[var18];
                    var6 += var19 >> 16 & 0xFF;
                    var7 += var19 >> 8 & 0xFF;
                    var8 += var19 & 0xFF;
                    int var20 = var17.grassColors[var18];
                    var9 += var20 >> 16 & 0xFF;
                    var10 += var20 >> 8 & 0xFF;
                    var11 += var20 & 0xFF;
                    int var21 = var17.waterColors[var18];
                    var12 += var21 >> 16 & 0xFF;
                    var13 += var21 >> 8 & 0xFF;
                    var14 += var21 & 0xFF;
                    ++var5;
                }
            }
            var4.smoothFoliageColors[var3] = (var6 / var5 & 0xFF) << 16 | (var7 / var5 & 0xFF) << 8 | var8 / var5 & 0xFF;
            var4.smoothGrassColors[var3] = (var9 / var5 & 0xFF) << 16 | (var10 / var5 & 0xFF) << 8 | var11 / var5 & 0xFF;
            var4.smoothWaterColors[var3] = (var12 / var5 & 0xFF) << 16 | (var13 / var5 & 0xFF) << 8 | var14 / var5 & 0xFF;
        }
    }

    static void init() {
        try {
            iz[] var0;
            Arrays.fill(cache, null);
            minecraft = reimm.getMinecraft();
            world = reimm.getWorld();
            seed = 0L;
            if (Minecraft.x().D() != null && (var0 = Minecraft.x().D().b) != null && var0.length >= 1) {
                seed = var0[0].F();
            }
            worldProvider = ChunkData.world.t;
            worldChunkManager = world.t();
            chunkProvider = world.J();
            chunkLoader = ChunkData.getChunkLoader(chunkProvider);
        }
        catch (Exception var1) {
            throw new RuntimeException(var1);
        }
    }

    private static abv getChunkLoader(abn var0) {
        try {
            for (Class<?> var1 = var0.getClass(); var1 != null; var1 = var1.getSuperclass()) {
                for (Field var5 : var1.getDeclaredFields()) {
                    if (var5.getType() != abv.class) continue;
                    var5.setAccessible(true);
                    return (abv)var5.get(var0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkData getChunkData(int var0, int var1) {
        int var2 = ChunkData.chunkPointer(var0, var1);
        ChunkData var3 = cache[var2];
        return var3 != null && var3.isAtLocation(var0, var1) ? var3 : null;
    }

    static ChunkData createChunkData(int var0, int var1) {
        int var2 = ChunkData.chunkPointer(var0, var1);
        ChunkData var3 = cache[var2];
        return var3 != null && var3.isAtLocation(var0, var1) ? var3 : new ChunkData(var0, var1);
    }

    private static int chunkPointer(int var0, int var1) {
        return (var1 & 0x1F) << 5 | var0 & 0x1F;
    }

    void setHeightValue(int var1, int var2, float var3) {
        this.heightValues[var2 << 4 | var1] = var3;
    }

    float getHeightValue(int var1, int var2) {
        return this.heightValues[var2 << 4 | var1];
    }

    static {
        Arrays.fill(PLAINS, aap.c);
        reimm = ReiMinimap.instance;
        cache = new ChunkData[1024];
    }
}

