/*
 * Decompiled with CFR 0.152.
 */
package gcewing.prospecting;

import cpw.mods.fml.client.FMLClientHandler;
import gcewing.prospecting.CoordRotator;
import gcewing.prospecting.GregsProspecting;
import gcewing.prospecting.ItemMiningRadar;
import gcewing.prospecting.RayTracer;
import gcewing.prospecting.Rendering;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.opengl.GL11;

public class RenderMiningRadar
extends Rendering
implements IItemRenderer {
    static String textureDir = "/gcewing/prospecting/resources/";
    static String mono_hud = textureDir + "mining_radar_hud.png";
    static String color_hud = textureDir + "color_mr_hud.png";
    static double hudWidth = 160.0;
    static double hudHeight = 160.0;
    static double screenLeft = 16.0;
    static double screenBottom = 48.0;
    static double screenWidth = 128.0;
    static double screenHeight = 96.0;
    static double fieldOfView = 90.0;
    static double tanA = Math.tan(fieldOfView / 2.0 * Math.PI / 180.0);
    static int hResolution = 32;
    static int vResolution = 24;
    static float[] phosphorColor = new float[]{1.0f, 0.85490197f, 0.08627451f};
    static float maxSignal = 10.0f;
    Minecraft mc;

    public RenderMiningRadar() {
        FMLClientHandler.instance().getClient();
        this.mc = Minecraft.x();
    }

    public boolean handleRenderType(ur ur2, IItemRenderer.ItemRenderType itemRenderType) {
        return itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ur ur2, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED && itemRendererHelper == IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK;
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ur ur2, Object ... objectArray) {
        switch (itemRenderType) {
            case INVENTORY: {
                this.renderInInventory(ur2, objectArray);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(ur2, objectArray);
                break;
            }
        }
    }

    void renderInInventory(ur ur2, Object[] objectArray) {
        bce bce2 = new bce();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        int n = ur2.c();
        bce2.a(0, 0, n % 16 * 16, n / 16 * 16, 16, 16);
        GL11.glDisable((int)3553);
        double d = this.batteryCondition(ur2);
        if (d < 1.0) {
            int n2 = (int)Math.round(13.0 * d);
            int n3 = (int)Math.round(255.0 * d);
            int n4 = 255 - n3 << 16 | n3 << 8;
            int n5 = (255 - n3) / 4 << 16 | 0x3F00;
            baz baz2 = baz.a;
            this.renderQuad(baz2, 2, 13, 13, 2, 0);
            this.renderQuad(baz2, 2, 13, 12, 1, n5);
            this.renderQuad(baz2, 2, 13, n2, 1, n4);
        }
        GL11.glPopAttrib();
    }

    void renderQuad(baz baz2, int n, int n2, int n3, int n4, int n5) {
        baz2.b();
        baz2.d(n5);
        baz2.a((double)(n + 0), (double)(n2 + 0), 0.0);
        baz2.a((double)(n + 0), (double)(n2 + n4), 0.0);
        baz2.a((double)(n + n3), (double)(n2 + n4), 0.0);
        baz2.a((double)(n + n3), (double)(n2 + 0), 0.0);
        baz2.a();
    }

    void renderEquipped(ur ur2, Object[] objectArray) {
        lq lq2 = (lq)objectArray[1];
        if (lq2 instanceof qx) {
            qx qx2 = (qx)lq2;
            FMLClientHandler.instance().getClient();
            Minecraft minecraft = Minecraft.x();
            if (qx2 == minecraft.g && minecraft.y.W == 0) {
                this.renderFirstPerson(ur2, qx2);
            } else {
                this.renderThirdPerson(ur2, qx2);
            }
        }
    }

    void renderThirdPerson(ur ur2, qx qx2) {
        GL11.glBindTexture((int)3553, (int)this.mc.o.b(ForgeHooks.getTexture((String)"/gui/items.png", (Object)ur2.b())));
        GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)-1.5, (double)0.7, (double)0.5);
        baz baz2 = baz.a;
        int n = 0;
        int n2 = qx2.b(ur2, n);
        float f = ((float)(n2 % 16 * 16) + 0.0f) / 256.0f;
        float f2 = ((float)(n2 % 16 * 16) + 15.99f) / 256.0f;
        float f3 = ((float)(n2 / 16 * 16) + 0.0f) / 256.0f;
        float f4 = ((float)(n2 / 16 * 16) + 15.99f) / 256.0f;
        this.renderItemIn2D(baz2, f2, f3, f, f4);
    }

    void renderItemIn2D(baz baz2, float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        int n;
        float f8 = 1.0f;
        float f9 = 0.0625f;
        GL11.glDisable((int)3553);
        baz2.b();
        baz2.b(0.0f, 0.0f, 1.0f);
        baz2.a(0.0, 0.0, 0.0, (double)f, (double)f4);
        baz2.a((double)f8, 0.0, 0.0, (double)f3, (double)f4);
        baz2.a((double)f8, 1.0, 0.0, (double)f3, (double)f2);
        baz2.a(0.0, 1.0, 0.0, (double)f, (double)f2);
        baz2.a();
        GL11.glEnable((int)3553);
        baz2.b();
        baz2.b(0.0f, 0.0f, -1.0f);
        baz2.a(0.0, 1.0, (double)(0.0f - f9), (double)f, (double)f2);
        baz2.a((double)f8, 1.0, (double)(0.0f - f9), (double)f3, (double)f2);
        baz2.a((double)f8, 0.0, (double)(0.0f - f9), (double)f3, (double)f4);
        baz2.a(0.0, 0.0, (double)(0.0f - f9), (double)f, (double)f4);
        baz2.a();
        baz2.b();
        baz2.b(-1.0f, 0.0f, 0.0f);
        for (n = 0; n < 16; ++n) {
            f7 = (float)n / 16.0f;
            f6 = f + (f3 - f) * f7 - 0.001953125f;
            f5 = f8 * f7;
            baz2.a((double)f5, 0.0, (double)(0.0f - f9), (double)f6, (double)f4);
            baz2.a((double)f5, 0.0, 0.0, (double)f6, (double)f4);
            baz2.a((double)f5, 1.0, 0.0, (double)f6, (double)f2);
            baz2.a((double)f5, 1.0, (double)(0.0f - f9), (double)f6, (double)f2);
        }
        baz2.a();
        baz2.b();
        baz2.b(1.0f, 0.0f, 0.0f);
        for (n = 0; n < 16; ++n) {
            f7 = (float)n / 16.0f;
            f6 = f + (f3 - f) * f7 - 0.001953125f;
            f5 = f8 * f7 + 0.0625f;
            baz2.a((double)f5, 1.0, (double)(0.0f - f9), (double)f6, (double)f2);
            baz2.a((double)f5, 1.0, 0.0, (double)f6, (double)f2);
            baz2.a((double)f5, 0.0, 0.0, (double)f6, (double)f4);
            baz2.a((double)f5, 0.0, (double)(0.0f - f9), (double)f6, (double)f4);
        }
        baz2.a();
        baz2.b();
        baz2.b(0.0f, 1.0f, 0.0f);
        for (n = 0; n < 16; ++n) {
            f7 = (float)n / 16.0f;
            f6 = f4 + (f2 - f4) * f7 - 0.001953125f;
            f5 = f8 * f7 + 0.0625f;
            baz2.a(0.0, (double)f5, 0.0, (double)f, (double)f6);
            baz2.a((double)f8, (double)f5, 0.0, (double)f3, (double)f6);
            baz2.a((double)f8, (double)f5, (double)(0.0f - f9), (double)f3, (double)f6);
            baz2.a(0.0, (double)f5, (double)(0.0f - f9), (double)f, (double)f6);
        }
        baz2.a();
        baz2.b();
        baz2.b(0.0f, -1.0f, 0.0f);
        for (n = 0; n < 16; ++n) {
            f7 = (float)n / 16.0f;
            f6 = f4 + (f2 - f4) * f7 - 0.001953125f;
            f5 = f8 * f7;
            baz2.a((double)f8, (double)f5, 0.0, (double)f3, (double)f6);
            baz2.a(0.0, (double)f5, 0.0, (double)f, (double)f6);
            baz2.a(0.0, (double)f5, (double)(0.0f - f9), (double)f, (double)f6);
            baz2.a((double)f8, (double)f5, (double)(0.0f - f9), (double)f3, (double)f6);
        }
        baz2.a();
    }

    void renderFirstPerson(ur ur2, qx qx2) {
        this.saveAttributes();
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)-0.5, (double)1.25, (double)0.75);
        GL11.glScaled((double)(1.0 / hudWidth), (double)(1.0 / hudHeight), (double)1.0);
        this.drawBackground(ur2);
        if (this.isBroken(ur2)) {
            this.drawCracks();
        } else if (this.hasPower(ur2)) {
            this.drawDisplay(qx2, ur2);
            this.drawIndicators(ur2);
        }
        this.restoreAttributes();
    }

    void saveAttributes() {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        bfe.a((int)bfe.b);
        GL11.glDisable((int)3553);
        bfe.a((int)bfe.a);
    }

    void restoreAttributes() {
        GL11.glPopAttrib();
    }

    void drawBackground(ur ur2) {
        ItemMiningRadar itemMiningRadar = (ItemMiningRadar)ur2.b();
        this.bindTexture(itemMiningRadar.isColor(ur2) ? color_hud : mono_hud);
        this.drawTexRect(0.0, 0.0, hudWidth, hudHeight, 0.0, 0.0, 1.0, 1.0);
    }

    void drawDisplay(qx qx2, ur ur2) {
        if (!(ur2.b() instanceof ItemMiningRadar)) {
            return;
        }
        ItemMiningRadar itemMiningRadar = (ItemMiningRadar)ur2.b();
        boolean bl = itemMiningRadar.isColor(ur2);
        double d = (double)(-qx2.A) * Math.PI / 180.0;
        double d2 = (double)(180.0f - qx2.z) * Math.PI / 180.0;
        CoordRotator coordRotator = new CoordRotator(d, d2);
        double d3 = screenWidth / (double)hResolution;
        double d4 = screenHeight / (double)vResolution;
        RayTracer rayTracer = new RayTracer(qx2, itemMiningRadar.getRange(ur2), itemMiningRadar.getSignalMode(ur2));
        baz baz2 = new baz();
        baz2.b(screenLeft, screenBottom, 0.0);
        baz2.b();
        double d5 = (double)(-(hResolution / 2)) / tanA;
        for (int i = 0; i < vResolution; ++i) {
            double d6 = (double)(i - vResolution / 2) + 0.5;
            for (int j = 0; j < hResolution; ++j) {
                double d7 = (double)(j - hResolution / 2) + 0.5;
                coordRotator.rotate(d7, d6, d5);
                float f = rayTracer.trace(coordRotator.x, coordRotator.y, coordRotator.z);
                float f2 = f / maxSignal;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                float f3 = 2.0f * f2 % 1.0f;
                if (bl) {
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    if (f3 < 0.5f) {
                        f5 = 2.0f * f3;
                        f4 = 1.0f - f5;
                    } else if (f3 < 0.75f) {
                        f6 = 4.0f * (f3 - 0.5f);
                        f5 = 1.0f - f5;
                    } else {
                        f4 = 4.0f * (f3 - 0.75f);
                        f6 = 1.0f - f5;
                    }
                    baz2.a(f2 * f4, f2 * f5, f2 * f6);
                } else {
                    baz2.a(f2 * phosphorColor[0], f2 * phosphorColor[1], f2 * phosphorColor[2]);
                }
                this.tessRect(baz2, (double)j * d3, (double)i * d4, d3, d4);
            }
        }
        baz2.a();
    }

    void drawCracks() {
        this.bindTexture("/gcewing/prospecting/resources/mining_radar_cracks.png");
        this.drawTexRect(14.0, 34.0, 132.0, 112.0, 0.0, 0.0, 1.0, 1.0);
    }

    void drawIndicators(ur ur2) {
        ItemMiningRadar itemMiningRadar = GregsProspecting.miningRadar;
        this.bindTextureSet("/gcewing/prospecting/resources/mining_radar_indicators.png", 83.0, 9.0);
        GL11.glEnable((int)3553);
        int n = 36;
        int n2 = 9;
        int n3 = 9;
        int n4 = itemMiningRadar.getRange(ur2) / 5 - 1;
        this.drawTexSubRect(19.0, n, n3, n2, n4 * n3, 0.0);
        int n5 = 0;
        int n6 = 0;
        switch (itemMiningRadar.getSignalMode(ur2)) {
            case Maximum: {
                n5 = 27;
                n6 = 17;
                break;
            }
            case Sum: {
                n5 = 44;
                n6 = 17;
                break;
            }
        }
        if (n5 != 0) {
            this.drawTexSubRect(33.0, n, n6, n2, n5, 0.0);
        }
        int n7 = (int)(18.0f * this.batteryCondition(ur2));
        this.drawTexSubRect(119.0, n, 22.0, n2, 61.0, 0.0);
        GL11.glDisable((int)3553);
        this.glColor3fv(phosphorColor);
        this.drawRect(140 - n7, n + 1, n7, n2 - 2);
    }

    float batteryCondition(ur ur2) {
        if (ur2 != null && ur2.b() instanceof ItemMiningRadar) {
            float f = ((ItemMiningRadar)ur2.b()).getBatteryCharge(ur2);
            ItemMiningRadar cfr_ignored_0 = (ItemMiningRadar)ur2.b();
            float f2 = ItemMiningRadar.maxBatteryCharge;
            return f / f2;
        }
        return 0.0f;
    }

    boolean hasPower(ur ur2) {
        if (ur2 != null && ur2.b() instanceof ItemMiningRadar) {
            int n = ((ItemMiningRadar)ur2.b()).getBatteryCharge(ur2);
            return n > 0;
        }
        return false;
    }

    boolean isBroken(ur ur2) {
        return ur2.c == GregsProspecting.brokenMiningRadar.cj;
    }

    void glColor3fv(float[] fArray) {
        GL11.glColor3f((float)fArray[0], (float)fArray[1], (float)fArray[2]);
    }
}

