/*
 * Decompiled with CFR 0.152.
 */
package gcewing.prospecting;

import gcewing.prospecting.GregsItem;
import gcewing.prospecting.SlimeData;
import java.util.Map;
import java.util.WeakHashMap;

public class ItemSlimophone
extends GregsItem {
    private static int maxBatteryCharge = 100000;
    private static double maximumRange = 160.0;
    private static String pingSound = "mob.slime.small";
    private static double omnidirectionalGain = 0.2;
    private static int numBars = 6;
    private static double barDecayFactor = 0.9;
    private static int cooldownTime = 30;
    public static double[] barIntensities = new double[numBars];
    private static boolean scanPerformed;
    private static Map slimeData;

    public ItemSlimophone(int n) {
        super(n);
        this.d(1);
        this.e(maxBatteryCharge);
        this.c(22);
        this.setNoRepair();
    }

    public void a(ur ur2, yc yc2, lq lq2, int n, boolean bl) {
        if (yc2.I) {
            ItemSlimophone.decayBars();
            scanPerformed = false;
        }
        if (this.hasPower(ur2)) {
            if (!yc2.I) {
                this.updateBattery(ur2);
            }
            if (yc2.I && !scanPerformed) {
                this.performScan(ur2, yc2, lq2, n, bl);
                scanPerformed = true;
            }
        }
    }

    private void performScan(ur ur2, yc yc2, lq lq2, int n, boolean bl) {
        double d = 0.0;
        if (lq2 instanceof qx) {
            qx qx2 = (qx)lq2;
            for (Object e : yc2.e) {
                if (!(e instanceof qo)) continue;
                qo qo2 = (qo)e;
                SlimeData slimeData = this.getSlimeData((lq)qo2);
                if (slimeData.cooldownTimer > 0) {
                    --slimeData.cooldownTimer;
                    continue;
                }
                if (qo2.u == slimeData.posY) continue;
                slimeData.posY = qo2.u;
                slimeData.cooldownTimer = cooldownTime;
                aoj aoj2 = aoj.a((double)qo2.t, (double)qo2.u, (double)qo2.v);
                aoj aoj3 = aoj.a((double)qx2.t, (double)qx2.u, (double)qx2.v);
                double d2 = aoj3.d(aoj2);
                if (!(d2 <= maximumRange)) continue;
                aoj aoj4 = aoj2.c(-aoj3.c, -aoj3.d, -aoj3.e);
                aoj aoj5 = qx2.Z();
                double d3 = Math.max(aoj4.a().b(aoj5), omnidirectionalGain);
                double d4 = d3 * (1.0 - d2 / maximumRange);
                yc2.a(qx2.t, qx2.u, qx2.v, pingSound, (float)d4, 1.0f, false);
                d = Math.max(d, d4);
            }
        }
        if (d > 0.0) {
            this.intensifyBars(d);
        }
    }

    private void dumpBarIntensities() {
        System.out.printf("ItemSlimophone: Bar intensities =", new Object[0]);
        for (int i = 0; i < numBars; ++i) {
            System.out.printf(" %.2f", barIntensities[i]);
        }
        System.out.printf("\n", new Object[0]);
    }

    private void intensifyBars(double d) {
        int n = (int)Math.round(d * (double)numBars);
        for (int i = 0; i < n; ++i) {
            ItemSlimophone.barIntensities[i] = 1.0;
        }
    }

    public static void decayBars() {
        int n = 0;
        while (n < numBars) {
            int n2 = n++;
            barIntensities[n2] = barIntensities[n2] * barDecayFactor;
        }
    }

    private boolean hasPower(ur ur2) {
        return ur2.j() < ur2.k();
    }

    private void updateBattery(ur ur2) {
        ur2.b(ur2.j() + 1);
    }

    private SlimeData getSlimeData(lq lq2) {
        SlimeData slimeData = (SlimeData)ItemSlimophone.slimeData.get(lq2);
        if (slimeData == null) {
            slimeData = new SlimeData();
            ItemSlimophone.slimeData.put(lq2, slimeData);
        }
        return slimeData;
    }

    public boolean n() {
        return true;
    }

    public boolean d_(ur ur2) {
        return false;
    }

    static {
        slimeData = new WeakHashMap();
    }
}

