/*
 * Decompiled with CFR 0.152.
 */
package gcewing.prospecting;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gcewing.prospecting.CommonProxy;
import gcewing.prospecting.GregsItem;
import gcewing.prospecting.ItemMiningRadar;
import gcewing.prospecting.ItemSlimophone;
import gcewing.prospecting.OrderedProperties;
import gcewing.prospecting.PacketHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

@Mod(modid="GregsProspecting", name="GregsProspecting", version="1.4.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, versionBounds="[1.4,1.5)", channels={"gce.prospecting"}, packetHandler=PacketHandler.class)
public class GregsProspecting {
    @Mod.Instance(value="GregsProspecting")
    public static GregsProspecting instance;
    @SidedProxy(clientSide="gcewing.prospecting.ClientProxy", serverSide="gcewing.prospecting.CommonProxy")
    public static CommonProxy proxy;
    public static ItemMiningRadar miningRadar;
    public static ItemMiningRadar colorMiningRadar;
    public static ItemMiningRadar industrialMiningRadar;
    public static ItemMiningRadar industrialMiningRadarCharged;
    public static up battery;
    public static up mandrel;
    public static up batteryCasing;
    public static up carbonRod;
    public static up electrolytePaste;
    public static up bowlAppleJuice;
    public static up carbonFilament;
    public static up cathodeRayTube;
    public static up magnetron;
    public static up fibreglassBoard;
    public static up microwaveHorn;
    public static up brokenMiningRadar;
    public static up slimophone;
    public static up parabolicMicrophone;
    public static up piezoTransducer;
    public static up quartzWafer;
    public static up triode;
    public static up ledBarGraph;
    public static up redPhosphor;
    public static up greenPhosphor;
    public static up bluePhosphor;
    public static up colorCRT;
    public static up colorMiningRadarCircuit;
    static File cfgFile;
    static OrderedProperties config;
    static Map idToName;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        cfgFile = fMLPreInitializationEvent.getSuggestedConfigurationFile();
    }

    @Mod.Init
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        this.loadConfig();
        this.registerItems();
        this.addRecipes();
        proxy.registerKeys();
        proxy.registerRenderers();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.saveConfig();
    }

    void loadConfig() {
        config = new OrderedProperties();
        try {
            config.load(new FileInputStream(cfgFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.printf("GregsProspecting: No existing config file\n", new Object[0]);
        }
        catch (IOException iOException) {
            System.out.printf("GregsProspecting: Failed to read %s\n%s\n", cfgFile.getPath(), iOException);
        }
        GregsProspecting.config.extended = false;
    }

    void saveConfig() {
        try {
            if (GregsProspecting.config.extended) {
                System.out.printf("GregsProspecting: Writing config file\n", new Object[0]);
                config.store(new FileOutputStream(cfgFile), "Greg's Prospecting Configuration File");
            }
        }
        catch (IOException iOException) {
            System.out.printf("GregsProspecting: Failed to %s\n%s\n", cfgFile.getPath(), iOException);
        }
    }

    static int getItemID(int n, String string) {
        int n2 = config.getInt(string, n);
        idToName.put(256 + n2, string);
        return n2;
    }

    private void registerItems() {
        miningRadar = new ItemMiningRadar(GregsProspecting.getItemID(3000, "miningRadar"), 17);
        this.addItem("Mining Rader", miningRadar);
        battery = this.addItem("Battery", this.newItemSI(3001, "battery", 6, 0));
        mandrel = this.addItem("Wooden Mandrel", this.newItemI(3002, "mandrel", 24));
        mandrel.a(mandrel);
        batteryCasing = this.addItem("Battery Casing", this.newItemI(3003, "batteryCasing", 1));
        carbonRod = this.addItem("Carbon Rod", this.newItemI(3004, "carbonRod", 6));
        electrolytePaste = this.addItem("Electrolyte Paste", this.newItemI(3005, "electrolytePaste", 11));
        bowlAppleJuice = this.addItem("Apple Juice", this.newItemI(3006, "bowlAppleJuice", 3));
        bowlAppleJuice.a(up.E);
        carbonFilament = this.addItem("Carbon Filament", this.newItemI(3007, "carbonFilament", 5));
        cathodeRayTube = this.addItem("Cathode Ray Tube", this.newItemI(3008, "cathodeRayTube", 7));
        magnetron = this.addItem("Magnetron", this.newItemI(3009, "magnetron", 15));
        fibreglassBoard = this.addItem("Fibreglass Board", this.newItemI(3010, "fibreglassBoard", 12));
        microwaveHorn = this.addItem("Microwave Horn", this.newItemI(3011, "microwaveHorn", 16));
        brokenMiningRadar = new ItemMiningRadar(GregsProspecting.getItemID(3012, "brokenMiningRadar"), 4);
        this.addItem("Broken Mining Radar", brokenMiningRadar);
        slimophone = this.addItem("Slimophone", new ItemSlimophone(GregsProspecting.getItemID(3013, "slimophone")));
        parabolicMicrophone = this.addItem("Parabolic Microphone", this.newItemI(3014, "parabolicMicrophone", 18));
        piezoTransducer = this.addItem("Piezo Transducer", this.newItemI(3015, "piezoTransducer", 19));
        quartzWafer = this.addItem("Quartz Wafer", this.newItemI(3016, "quartzWafer", 20));
        triode = this.addItem("Triode", this.newItemI(3017, "triode", 23));
        ledBarGraph = this.addItem("LED Bar Graph", this.newItemI(3018, "ledBarGraph", 14));
        colorMiningRadar = new ItemMiningRadar(GregsProspecting.getItemID(3019, "colorMiningRadar"), 9);
        this.addItem("Colour Mining Radar", colorMiningRadar);
        redPhosphor = this.addItem("Red Phosphor", this.newItemI(3020, "redPhosphor", 21));
        greenPhosphor = this.addItem("Green Phosphor", this.newItemI(3021, "greenPhosphor", 13));
        bluePhosphor = this.addItem("Blue Phosphor", this.newItemI(3022, "bluePhosphor", 2));
        colorCRT = this.addItem("Colour CRT", this.newItemI(3023, "colorCRT", 8));
        colorMiningRadarCircuit = this.addItem("Colour Mining Radar Circuit", this.newItemI(3024, "colorMiningRadarCircuit", 10));
    }

    void addRecipes() {
        this.addShapelessRecipe(miningRadar, 1, new ur((up)miningRadar, 1, -1), battery);
        this.addRecipe(mandrel, 1, "W", "W", "W", Character.valueOf('W'), amq.A);
        this.addShapelessRecipe(batteryCasing, 6, up.o, mandrel);
        this.addRecipe(carbonRod, 6, "C", "C", "C", Character.valueOf('C'), up.m);
        this.addShapelessRecipe(bowlAppleJuice, 1, up.j, up.E);
        this.addShapelessRecipe(electrolytePaste, 6, bowlAppleJuice, new ur(up.aW, 1, 15));
        this.addShapelessRecipe(battery, 1, batteryCasing, electrolytePaste, carbonRod);
        this.addSmeltingRecipe(carbonFilament, 1, up.K);
        this.addRecipe(cathodeRayTube, 1, "|gG", "|gf", "|gG", Character.valueOf('|'), amq.bt, Character.valueOf('g'), up.aT, Character.valueOf('G'), amq.P, Character.valueOf('f'), carbonFilament);
        this.addRecipe(magnetron, 1, "rGr", "IGI", "rfr", Character.valueOf('r'), up.aC, Character.valueOf('G'), amq.P, Character.valueOf('I'), up.o, Character.valueOf('f'), carbonFilament);
        this.addShapelessRecipe(fibreglassBoard, 1, amq.P, up.aM);
        this.addRecipe(microwaveHorn, 1, "  I", "II ", "  I", Character.valueOf('I'), up.o);
        this.addRecipe(miningRadar, 1, "CMH", "LFB", "grg", Character.valueOf('C'), cathodeRayTube, Character.valueOf('M'), magnetron, Character.valueOf('H'), microwaveHorn, Character.valueOf('L'), amq.aM, Character.valueOf('F'), fibreglassBoard, Character.valueOf('B'), battery, Character.valueOf('g'), up.bq, Character.valueOf('r'), up.aC);
        this.addRecipe(slimophone, 1, "ltp", "grb", Character.valueOf('l'), ledBarGraph, Character.valueOf('t'), triode, Character.valueOf('p'), parabolicMicrophone, Character.valueOf('g'), up.bq, Character.valueOf('r'), up.aC, Character.valueOf('b'), battery);
        this.addRecipe(ledBarGraph, 1, "rgB", "rgB", "rgB", Character.valueOf('r'), up.aC, Character.valueOf('g'), up.aT, Character.valueOf('B'), new ur(amq.ae, 1, 15));
        this.addShapelessRecipe(slimophone, 1, new ur(slimophone, 1, -1), battery);
        this.addRecipe(parabolicMicrophone, 1, " W", "Wp", " W", Character.valueOf('W'), amq.A, Character.valueOf('p'), piezoTransducer);
        this.addRecipe(piezoTransducer, 1, "IqI", Character.valueOf('I'), up.o, Character.valueOf('q'), quartzWafer);
        this.addSmeltingRecipe(quartzWafer, 1, amq.T);
        this.addRecipe(triode, 1, " I ", "GrG", " f ", Character.valueOf('I'), up.o, Character.valueOf('G'), amq.P, Character.valueOf('r'), up.aC, Character.valueOf('f'), carbonFilament);
        this.addShapelessRecipe(redPhosphor, 1, up.bw, new ur(up.aW, 1, 1));
        this.addShapelessRecipe(greenPhosphor, 1, up.bw, new ur(up.aW, 1, 2));
        this.addShapelessRecipe(bluePhosphor, 1, up.bw, new ur(up.aW, 1, 4));
        this.addRecipe(colorCRT, 1, "|rf", "|gf", "|bf", Character.valueOf('|'), amq.bt, Character.valueOf('r'), redPhosphor, Character.valueOf('g'), greenPhosphor, Character.valueOf('b'), bluePhosphor, Character.valueOf('f'), carbonFilament);
        this.addRecipe(colorMiningRadarCircuit, 1, "rrr", " b ", " I ", Character.valueOf('r'), up.aC, Character.valueOf('b'), fibreglassBoard, Character.valueOf('I'), up.o);
        this.addShapelessRecipe(colorMiningRadar, 1, new Object[]{miningRadar, colorCRT, colorMiningRadarCircuit});
        this.addRecipe(colorMiningRadar, 1, "CMH", "LFB", "grg", Character.valueOf('C'), colorCRT, Character.valueOf('M'), magnetron, Character.valueOf('H'), microwaveHorn, Character.valueOf('L'), amq.aM, Character.valueOf('F'), colorMiningRadarCircuit, Character.valueOf('B'), battery, Character.valueOf('g'), up.bq, Character.valueOf('r'), up.aC);
        this.addShapelessRecipe(colorMiningRadar, 1, new ur((up)colorMiningRadar, 1, -1), battery);
    }

    private void addRecipe(up up2, int n, Object ... objectArray) {
        GameRegistry.addRecipe((ur)new ur(up2, n), (Object[])objectArray);
    }

    private void addShapelessRecipe(up up2, int n, Object ... objectArray) {
        GameRegistry.addShapelessRecipe((ur)new ur(up2, n), (Object[])objectArray);
    }

    private void addSmeltingRecipe(up up2, int n, up up3) {
        GameRegistry.addSmelting((int)up3.cj, (ur)new ur(up2, n), (float)0.0f);
    }

    private void addSmeltingRecipe(up up2, int n, amq amq2) {
        GameRegistry.addSmelting((int)amq2.cm, (ur)new ur(up2, n), (float)0.0f);
    }

    private up newItem(int n, String string) {
        return new GregsItem(GregsProspecting.getItemID(n, string));
    }

    private up newItemI(int n, String string, int n2) {
        return new GregsItem(GregsProspecting.getItemID(n, string)).c(n2);
    }

    private up newItemSI(int n, String string, int n2, int n3) {
        return new GregsItem(GregsProspecting.getItemID(n, string)).d(n2).c(n3);
    }

    private up addItem(String string, up up2) {
        up2.b("gcewing." + (String)idToName.get(up2.cj));
        LanguageRegistry.addName((Object)up2, (String)string);
        return up2;
    }

    static {
        idToName = new Hashtable();
    }
}

