/*
 * Decompiled with CFR 0.152.
 */
package gcewing.prospecting;

import cpw.mods.fml.client.FMLClientHandler;
import gcewing.prospecting.SignalMode;

public class RayTracer {
    private int range;
    private double x0;
    private double y0;
    private double z0;
    private SignalMode signalMode;
    private float[][][] density;
    private static float gain = 2.0f;
    private static float[] reflectance = new float[amq.p.length];

    public RayTracer(qx qx2, int n, SignalMode signalMode) {
        this.range = n;
        this.signalMode = signalMode;
        yc yc2 = qx2.p;
        double d = qx2.t;
        double d2 = qx2.u;
        double d3 = qx2.v;
        int n2 = (int)Math.floor(d);
        int n3 = (int)Math.floor(d2);
        int n4 = (int)Math.floor(d3);
        this.x0 = d - (double)n2 - 0.5;
        this.y0 = d2 - (double)n3 - 0.5;
        this.z0 = d3 - (double)n4 - 0.5;
        int n5 = 2 * n + 1;
        this.density = new float[n5][n5][n5];
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                for (int k = -n; k <= n; ++k) {
                    int n6 = yc2.a(n2 + i, n3 + j, n4 + k);
                    this.density[n + i][n + j][n + k] = reflectance[n6];
                }
            }
        }
    }

    private void dump() {
        int n;
        System.out.printf("%3s", "");
        for (n = 0; n <= 2 * this.range; ++n) {
            System.out.printf(" %5d", n);
        }
        System.out.printf("\n", new Object[0]);
        for (n = 0; n <= 2 * this.range; ++n) {
            System.out.printf("%3d", n);
            for (int i = 0; i <= 2 * this.range; ++i) {
                float f = 0.0f;
                for (int j = 0; j <= 2 * this.range; ++j) {
                    f += this.density[i][j][n];
                }
                System.out.printf(" %5.1f", Float.valueOf(f));
            }
            System.out.printf("\n", new Object[0]);
        }
    }

    public float trace(double d, double d2, double d3) {
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        if (d4 >= d5 && d4 >= d6) {
            if (d > 0.0) {
                return this.traceCase(d, d2, d3, 1.0, d2 / d, d3 / d);
            }
            return this.traceCase(d, d2, d3, -1.0, -d2 / d, -d3 / d);
        }
        if (d5 >= d4 && d5 >= d6) {
            if (d2 > 0.0) {
                return this.traceCase(d, d2, d3, d / d2, 1.0, d3 / d2);
            }
            return this.traceCase(d, d2, d3, -d / d2, -1.0, -d3 / d2);
        }
        if (d3 > 0.0) {
            return this.traceCase(d, d2, d3, d / d3, d2 / d3, 1.0);
        }
        return this.traceCase(d, d2, d3, -d / d3, -d2 / d3, -1.0);
    }

    private float traceCase(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = this.range;
        float f = 0.0f;
        int n2 = 0;
        block5: for (int i = 1; i <= n; ++i) {
            double d7 = this.x0 + (double)i * d4;
            double d8 = this.y0 + (double)i * d5;
            double d9 = this.z0 + (double)i * d6;
            int n3 = (int)Math.round(d7);
            int n4 = (int)Math.round(d8);
            int n5 = (int)Math.round(d9);
            if (n3 < -n || n3 > n || n4 < -n || n4 > n || n5 < -n || n5 > n) break;
            float f2 = this.density[n + n3][n + n4][n + n5];
            switch (this.signalMode) {
                case Average: {
                    f += f2;
                    ++n2;
                }
                case Sum: {
                    f += f2;
                    n2 = 1;
                    continue block5;
                }
                case Maximum: {
                    if (!(f2 > f)) continue block5;
                    f = f2;
                    n2 = 1;
                }
            }
        }
        if (n2 > 0) {
            f /= (float)n2;
        }
        if (this.signalMode != SignalMode.Maximum) {
            f /= (float)(this.range / 5);
        }
        if (this.signalMode == SignalMode.Maximum) {
            f *= gain;
        }
        return f;
    }

    static {
        ayp ayp2 = FMLClientHandler.instance().getClient().e;
        for (amq amq2 : amq.p) {
            if (amq2 == null) continue;
            RayTracer.reflectance[amq2.cm] = amq2.m((yc)ayp2, 0, 0, 0);
        }
        RayTracer.reflectance[amq.E.cm] = 1.75f;
        RayTracer.reflectance[amq.D.cm] = 1.75f;
        RayTracer.reflectance[amq.M.cm] = 0.75f;
        RayTracer.reflectance[amq.A.cm] = 0.5f;
        RayTracer.reflectance[amq.bc.cm] = reflectance[amq.A.cm];
        RayTracer.reflectance[amq.by.cm] = reflectance[amq.A.cm];
        RayTracer.reflectance[amq.aw.cm] = reflectance[amq.A.cm];
        RayTracer.reflectance[amq.aH.cm] = reflectance[amq.A.cm];
        RayTracer.reflectance[amq.bn.cm] = reflectance[amq.A.cm];
        RayTracer.reflectance[amq.z.cm] = reflectance[amq.w.cm] - 0.2f;
        RayTracer.reflectance[amq.ar.cm] = reflectance[amq.z.cm];
        RayTracer.reflectance[amq.aK.cm] = reflectance[amq.z.cm];
        RayTracer.reflectance[amq.ao.cm] = 1.0f;
        RayTracer.reflectance[amq.bz.cm] = reflectance[amq.ao.cm];
        RayTracer.reflectance[amq.G.cm] = reflectance[amq.w.cm];
        RayTracer.reflectance[amq.F.cm] = reflectance[amq.w.cm];
        RayTracer.reflectance[amq.L.cm] = 2.5f;
        RayTracer.reflectance[amq.K.cm] = 3.0f;
        RayTracer.reflectance[amq.aQ.cm] = 3.2f;
        RayTracer.reflectance[amq.J.cm] = 3.5f;
        RayTracer.reflectance[amq.Q.cm] = 4.0f;
        RayTracer.reflectance[amq.as.cm] = 4.25f;
        RayTracer.reflectance[amq.az.cm] = 4.5f;
        RayTracer.reflectance[amq.al.cm] = 3.0f;
        RayTracer.reflectance[amq.ak.cm] = 3.5f;
        RayTracer.reflectance[amq.R.cm] = 4.0f;
        RayTracer.reflectance[amq.aA.cm] = 4.5f;
    }
}

