/*
 * Decompiled with CFR 0.152.
 */
package net.rubeAurora;

import net.rubeAurora.Color;
import net.rubeAurora.Debug;
import net.rubeAurora.EnumColors;
import net.rubeAurora.IDebug;

public class Node
implements IDebug {
    private static int subNodes;
    private static int nodeLength;
    private float angle;
    public float posX = 1.0f;
    public float posZ = 1.0f;
    public float posY = 7.0f;
    private float modZ = 0.0f;
    private float modX = 0.0f;
    private float modY = 0.0f;
    private float tetX = 0.0f;
    private float tetX2 = 0.0f;
    private float tetZ = 0.0f;
    private float tetZ2 = 0.0f;
    public float width = 30.0f;
    public int alpha = 1;
    private int modA = 0;
    public Color color = new Color(EnumColors.TURQOISE);

    public Node(float x, float z, float theta) {
        this.posX = x;
        this.posZ = z;
        this.angle = theta;
    }

    public Node(float x, float y, float z, float theta) {
        this(x, z, theta);
        this.posY = y;
    }

    public Node(float x, float y, float z, float theta, int alph) {
        this(x, y, z, theta);
        this.alpha = alph;
    }

    public Node(float x, float y, float z, float theta, EnumColors c) {
        this(x, y, z, theta);
        this.color.setColor(c);
    }

    public void setTet(float x, float x2, float z, float z2) {
        this.tetX = x;
        this.tetX2 = x2;
        this.tetZ = z;
        this.tetZ2 = z2;
    }

    public float[] getTet() {
        float[] f = new float[]{this.tetX, this.tetX2, this.tetZ, this.tetZ2};
        return f;
    }

    public void setModAlph(int f) {
        this.modA = f;
    }

    public void setModZ(float f) {
        this.modZ = f;
    }

    public void setModX(float f) {
        this.modX = f;
    }

    public void setModY(float f) {
        this.modY = f;
    }

    public float getModdedZ() {
        return this.posZ + this.modZ;
    }

    public float getModdedX() {
        return this.posX + this.modX;
    }

    public float getModdedY() {
        float y = this.posY + this.modY;
        if (y < 0.0f) {
            y = 0.0f;
        }
        return y;
    }

    public int getModdedAlph() {
        return this.alpha + this.modA;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(x, z);
        this.posY = y;
    }

    public void setPosition(float x, float z) {
        this.posX = x;
        this.posZ = z;
    }

    public void setPosistionAndAngle(float x, float z, float angle) {
        this.setPosition(x, z);
        this.setAngle(angle);
    }

    public float getAngle() {
        return this.angle;
    }

    public float[] getPosition() {
        float[] f = new float[]{this.posX, this.posZ};
        return f;
    }

    public static int nodDistance(Node node1, Node node2) {
        float dX = node1.posX - node2.posX;
        float dZ = node1.posZ - node2.posZ;
        double sum = Math.pow(Math.pow(dX, 2.0) + Math.pow(dZ, 2.0), 0.5);
        return (int)sum;
    }

    public void translateNextNode(Node node) {
        float tranX = this.posX;
        float tranZ = this.posZ;
        for (int i = 0; i < subNodes; ++i) {
            tranZ = (float)((double)tranZ + Math.sin((double)this.angle / 57.29577951308232) * (double)nodeLength);
            tranX = (float)((double)tranX + Math.cos((double)this.angle / 57.29577951308232) * (double)nodeLength);
        }
        node.setPosition(tranZ, tranX);
    }

    public void printNode() {
        Debug.println(this, "X = " + this.posX + " Z = " + this.posZ);
    }

    public void addX(float f) {
        this.posX += f;
    }

    public void addZ(float f) {
        this.posZ += f;
    }

    public void addA(int a) {
        if (this.alpha >= 1) {
            this.alpha += a;
        }
    }

    @Override
    public String name() {
        return "Node";
    }
}

