/*
 * Decompiled with CFR 0.152.
 */
package net.rubeAurora;

import net.rubeAurora.ColorShifter;
import net.rubeAurora.EnumColors;

public class Color {
    private int red;
    private int green;
    private int blue;
    private int alpha = 128;
    public EnumColors lastColor = EnumColors.RED;

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.lastColor = this.closestColor();
    }

    public Color(int red, int green, int blue, int alpha) {
        this(red, green, blue);
        this.alpha = alpha;
    }

    public Color(EnumColors s) {
        this.red = s.red;
        this.green = s.green;
        this.blue = s.blue;
        this.lastColor = s;
    }

    public Color(EnumColors s, int alpha) {
        this(s);
        this.alpha = alpha;
    }

    public void setRed(int i) {
        this.red = i;
    }

    public void setGreen(int i) {
        this.green = i;
    }

    public void setBlue(int i) {
        this.blue = i;
    }

    public void setAlpha(int i) {
        this.alpha = i;
    }

    public void setColor(EnumColors c) {
        this.lastColor = c;
        this.red = c.red;
        this.green = c.green;
        this.blue = c.blue;
    }

    public int[] getColors() {
        return new int[]{this.red, this.green, this.blue, this.alpha};
    }

    public void incRed(int i) {
        this.red += i;
    }

    public void incGreen(int i) {
        this.green += i;
    }

    public void incBlue(int i) {
        this.blue += i;
    }

    public void incAlpha(int i) {
        this.alpha += i;
    }

    public boolean equals(EnumColors c) {
        if (c.red == this.red && c.green == this.green && this.blue == c.blue) {
            this.lastColor = c;
            return true;
        }
        return false;
    }

    private int closestTo(int i) {
        if (i >= 0 && i <= 63) {
            return 0;
        }
        if (i > 63 && i <= 127) {
            return 127;
        }
        return 255;
    }

    public EnumColors closestColor() {
        int red = this.closestTo(this.red);
        int green = this.closestTo(this.green);
        int blue = this.closestTo(this.blue);
        return (EnumColors)((Object)ColorShifter.instance.ColorMap.get(new int[]{red, green, blue}));
    }
}

