package gravigun.api;

import java.lang.reflect.Array;

public final class Api {
	
	/**
	 * Adds a blockID to the gravigun block grabbing blacklist. Non-metadata specific.
	 * @param blockID
	 */
	public static void addBlockIDToGrabList(int blockID) {
		addBlockIDToGrabList(blockID, new int[] { -1 });
	}
	
	/**
	 * Adds a blockID to the gravigun block grabbing blacklist. Metadata specific with metadata in the int[]. Set to null to remove from blacklist.
	 * @param blockID
	 * @param metadata
	 */
	public static void addBlockIDToGrabList(int blockID, int[] metadata) {
		try {
			Class.forName("gravigun.common.GraviGun").getMethod("addBlockIDToGrabList", Integer.class, Array.newInstance(Integer.class, 0).getClass()).invoke(null, blockID, metadata);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
