// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.Random;

public class PigGrinderEntity extends EntityPig
{
	public PigGrinderEntity(World world)
	{
		super(world);
		tickCount = 0;
		timesToExp = (mod_PigGrinder.grinderYields + rand.nextInt(8));
		canExplode = mod_PigGrinder.canExplode;
		texNum = 0;
		texTickCount = 0;
	}

	public PigGrinderEntity(World world, EntityPig p, boolean setGrinder)
	{
		this(world);
		NBTTagCompound tag = new NBTTagCompound();
		p.writeEntityToNBT(tag);
		this.readEntityFromNBT(tag);

		tickCount = 0;
		timesToExp = (mod_PigGrinder.grinderYields + rand.nextInt(8));
		canExplode = mod_PigGrinder.canExplode;
		texNum = 0;
		texTickCount = 0;

		entityToAttack = p.entityToAttack;
		try
		{
			int Fire = (Integer)ModLoader.getPrivateValue(Entity.class, p, "fire");
			Fire = (int)Math.ceil(Fire / 20);
			setFire(Fire);
		}
		catch(Exception e)
		{
			try
			{
				int Fire = (Integer)ModLoader.getPrivateValue(Entity.class, p, "c");
				Fire = (int)Math.ceil(Fire / 20);
				setFire(Fire);
			}
			catch(Exception e1)
			{
				mod_PigGrinder.console("Forgot to update obfuscation!");
				e1.printStackTrace();
			}
		}
		renderYawOffset = p.renderYawOffset;
		hasAttacked = p.hasAttacked;
		entityAge = p.entityAge;
		isJumping = p.isJumping;
		setLocationAndAngles(p.posX, p.posY, p.posZ, p.rotationYaw, p.rotationPitch);
		setGrinder(setGrinder);
	}

	@Override
	protected void entityInit()
	{
		super.entityInit();
		//        dataWatcher.addObject(16, Byte.valueOf((byte)0));
	}

	@Override
	public void writeEntityToNBT(NBTTagCompound nbttagcompound)
	{
		super.writeEntityToNBT(nbttagcompound);
		nbttagcompound.setBoolean("canExplode", canExplode);
		nbttagcompound.setBoolean("Grinder", getGrinder());
		nbttagcompound.setInteger("tickCount", tickCount);
		nbttagcompound.setInteger("timesToExp", timesToExp);
		nbttagcompound.setInteger("texNum", texNum);
		nbttagcompound.setInteger("texTickCount", texTickCount);
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readEntityFromNBT(nbttagcompound);
		setGrinder(nbttagcompound.getBoolean("Grinder"));
		canExplode = nbttagcompound.getBoolean("canExplode");
		tickCount = nbttagcompound.getInteger("tickCount");
		timesToExp = nbttagcompound.getInteger("timesToExp");
		texNum = nbttagcompound.getInteger("texNum");
		texTickCount = nbttagcompound.getInteger("texTickCount");
	}
	
	@Override
    protected void dropFewItems(boolean par1, int par2)
    {
        int var3 = this.rand.nextInt(3) + 1 + this.rand.nextInt(1 + par2);

        for (int var4 = 0; var4 < var3; ++var4)
        {
            if (this.isBurning())
            {
                this.dropItem(Item.porkCooked.shiftedIndex, 1);
            }
            else
            {
                this.dropItem(Item.porkRaw.shiftedIndex, 1);
            }
        }

        if (this.getSaddled())
        {
            this.dropItem(mod_PigGrinder.PigGrinderItem.shiftedIndex, 1);
        }
    }

	@Override
	public void onUpdate()
	{
		super.onUpdate();
		tickCount++;
		if(getGrinder())
		{
			if(texTickCount < 1)
			{
				texNum++;
				if(texNum > 3)
				{
					texNum = 1;
				}
				//				texture = (new StringBuilder()).append("/piggrinder/pigg_").append(texNum).append(".png").toString();
				texTickCount = 2;
			}
			texTickCount--;
			if(tickCount > mod_PigGrinder.frequency)
			{
				if(!worldObj.isRemote)
				{
					EntityItem entityitem = new EntityItem(worldObj, posX, posY + 0.5D, posZ, new ItemStack(getDropItemId(), 1, 0));
					entityitem.delayBeforeCanPickup = 10;
					entityitem.motionY = (double)((2 * mod_PigGrinder.tossPower) * (rand.nextInt(5) + 1));
					if(rand.nextInt(2) == 0)
					{
						entityitem.motionX = -(double)(mod_PigGrinder.tossPower * (rand.nextInt(mod_PigGrinder.tossMultiplier) + 1));
					}
					else
					{
						entityitem.motionX = (double)(mod_PigGrinder.tossPower * (rand.nextInt(mod_PigGrinder.tossMultiplier) + 1));
					}
					if(rand.nextInt(2) == 0)
					{
						entityitem.motionZ = -(double)(mod_PigGrinder.tossPower * (rand.nextInt(mod_PigGrinder.tossMultiplier) + 1));
					}
					else
					{
						entityitem.motionZ = (double)(mod_PigGrinder.tossPower * (rand.nextInt(mod_PigGrinder.tossMultiplier) + 1));
					}
					worldObj.spawnEntityInWorld(entityitem);
				}
				timesToExp--;
				tickCount = 0;
			}
			if(canExplode && !worldObj.isRemote)
			{
				if(timesToExp < 1)
				{
					setDead();
					for(int i1 = 0; i1 < 15; i1++)
					{
						double d = rand.nextGaussian() * 0.02D;
						double d1 = rand.nextGaussian() * 0.02D;
						double d2 = rand.nextGaussian() * 0.02D;
						worldObj.spawnParticle("largesmoke", (posX + (double)(rand.nextFloat() * 2.0F)) - 1, posY + (double)(rand.nextFloat()), (posZ + (double)(rand.nextFloat() * 2.0F)) - 1, d, d1, d2);
					}
					worldObj.createExplosion(this, posX, posY, posZ, mod_PigGrinder.explosionMag, worldObj.getGameRules().getGameRuleBooleanValue("mobGriefing"));
				}
			}
		}
	}

	@Override
	public boolean interact(EntityPlayer entityplayer)
	{
		ItemStack var2 = entityplayer.inventory.getCurrentItem();
		if (var2 != null && var2.itemID == Item.wheat.shiftedIndex && this.getGrowingAge() == 0)
		{
			if (!entityplayer.capabilities.isCreativeMode)
			{
				--var2.stackSize;

				if (var2.stackSize <= 0)
				{
					entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, (ItemStack)null);
				}
			}

			try
			{
				ModLoader.setPrivateValue(EntityAnimal.class, this, "inLove", (int)600);
			}
			catch(Exception e)
			{
				try
				{
					ModLoader.setPrivateValue(EntityAnimal.class, this, "d", (int)600);
				}
				catch(Exception e1)
				{
					mod_PigGrinder.console("Forgot to update obfuscation!");
					e1.printStackTrace();
				}

			}
			this.entityToAttack = null;

			for (int var3 = 0; var3 < 7; ++var3)
			{
				double var4 = this.rand.nextGaussian() * 0.02D;
				double var6 = this.rand.nextGaussian() * 0.02D;
				double var8 = this.rand.nextGaussian() * 0.02D;
				this.worldObj.spawnParticle("heart", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0F) - (double)this.width, this.posY + 0.5D + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0F) - (double)this.width, var4, var6, var8);
			}

			return true;
		}
		else
		{
			ItemStack itemstack = entityplayer.inventory.getCurrentItem();
			if(itemstack != null && itemstack.itemID == Item.saddle.shiftedIndex)
			{
				setDead();
				EntityPig pig = new EntityPig(worldObj);
				pig.entityToAttack = entityToAttack;
				pig.renderYawOffset = renderYawOffset;
				try
				{
					int Fire = (Integer)ModLoader.getPrivateValue(Entity.class, pig, "fire");
					Fire = (int)Math.ceil(Fire / 20);
					pig.setFire(Fire);
				}
				catch(Exception e)
				{
					try
					{
						int Fire = (Integer)ModLoader.getPrivateValue(Entity.class, pig, "c");
						Fire = (int)Math.ceil(Fire / 20);
						pig.setFire(Fire);
					}
					catch(Exception e1)
					{
						mod_PigGrinder.console("Forgot to update obfuscation!");
						e1.printStackTrace();
					}
				}
				pig.hasAttacked = hasAttacked;
				pig.entityAge = entityAge;
				pig.isJumping = isJumping;
				pig.health = health;
				pig.setLocationAndAngles(posX, posY, posZ, rotationYaw, rotationPitch);
				worldObj.spawnEntityInWorld(pig);
				dropItem(mod_PigGrinder.PigGrinderItem.shiftedIndex, 1);
				return true;
			}
		}
		return false;
	}

	@Override
	protected int getDropItemId()
	{
		if(isBurning())
		{
			return Item.porkCooked.shiftedIndex;
		} else
		{
			return Item.porkRaw.shiftedIndex;
		}
	}

	public boolean getGrinder()
	{
		return (dataWatcher.getWatchableObjectByte(16) & 1) != 0;
	}

	public void setGrinder(boolean flag)
	{
		if(flag)
		{
			dataWatcher.updateObject(16, Byte.valueOf((byte)1));
		} else
		{
			dataWatcher.updateObject(16, Byte.valueOf((byte)0));
		}
	}

	@Override
	public void onStruckByLightning(EntityLightningBolt entitylightningbolt)
	{
		if(worldObj.isRemote)
		{
			return;
		} else
		{
			EntityPigZombie entitypigzombie = new EntityPigZombie(worldObj);
			entitypigzombie.setLocationAndAngles(posX, posY, posZ, rotationYaw, rotationPitch);
			worldObj.spawnEntityInWorld(entitypigzombie);
			setDead();
			return;
		}
	}

	public int tickCount;
	public int timesToExp;
	public int texNum;
	public int texTickCount;
	public boolean canExplode;
}
