/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksItemTree {
    public static final int MAX_CATEGORY_RANGE = 1000;
    public static final String UNKNOWN_ITEM = "unknown";
    private static final Logger log = InvTweaks.log;
    private Map categories = new HashMap();
    private Map itemsById = new HashMap(500);
    private static Vector defaultItems = null;
    private Map itemsByName = new HashMap(500);
    private String rootCategory;

    public InvTweaksItemTree() {
        this.reset();
    }

    public void reset() {
        if (defaultItems == null) {
            defaultItems = new Vector();
            defaultItems.add(new InvTweaksItemTreeItem(UNKNOWN_ITEM, -1, -1, Integer.MAX_VALUE));
        }
        this.categories.clear();
        this.itemsByName.clear();
        this.itemsById.clear();
    }

    public boolean matches(List list, String string) {
        if (list == null) {
            return false;
        }
        for (Object object : list) {
            if (((InvTweaksItemTreeItem)object).getName() == null || !((InvTweaksItemTreeItem)object).getName().equals(string)) continue;
            return true;
        }
        InvTweaksItemTreeCategory invTweaksItemTreeCategory = this.getCategory(string);
        if (invTweaksItemTreeCategory != null) {
            for (InvTweaksItemTreeItem invTweaksItemTreeItem : list) {
                if (!invTweaksItemTreeCategory.contains(invTweaksItemTreeItem)) continue;
                return true;
            }
        }
        return string.equals(this.rootCategory);
    }

    public int getKeywordDepth(String string) {
        try {
            return this.getRootCategory().findKeywordDepth(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return 0;
        }
    }

    public int getKeywordOrder(String string) {
        List list = this.getItems(string);
        if (list != null && list.size() != 0) {
            return ((InvTweaksItemTreeItem)list.get(0)).getOrder();
        }
        try {
            return this.getRootCategory().findCategoryOrder(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return -1;
        }
    }

    public boolean isKeywordValid(String string) {
        if (this.containsItem(string)) {
            return true;
        }
        InvTweaksItemTreeCategory invTweaksItemTreeCategory = this.getCategory(string);
        return invTweaksItemTreeCategory != null;
    }

    public Collection getAllCategories() {
        return this.categories.values();
    }

    public InvTweaksItemTreeCategory getRootCategory() {
        return (InvTweaksItemTreeCategory)this.categories.get(this.rootCategory);
    }

    public InvTweaksItemTreeCategory getCategory(String string) {
        return (InvTweaksItemTreeCategory)this.categories.get(string);
    }

    public boolean isItemUnknown(int n, int n2) {
        return this.itemsById.get(n) == null;
    }

    public List getItems(int n, int n2) {
        Object object;
        List list = (List)this.itemsById.get(n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list != null && !list.isEmpty()) {
            for (InvTweaksItemTreeItem invTweaksItemTreeItem : list) {
                if (invTweaksItemTreeItem.getDamage() == -1 || invTweaksItemTreeItem.getDamage() == n2) continue;
                arrayList.remove(invTweaksItemTreeItem);
            }
        }
        if (arrayList.isEmpty()) {
            InvTweaksItemTreeItem invTweaksItemTreeItem;
            object = new InvTweaksItemTreeItem(String.format("%d-%d", n, n2), n, n2, 5000 + n * 16 + n2);
            invTweaksItemTreeItem = new InvTweaksItemTreeItem(Integer.toString(n), n, -1, 5000 + n * 16);
            this.addItem(this.getRootCategory().getName(), (InvTweaksItemTreeItem)object);
            this.addItem(this.getRootCategory().getName(), invTweaksItemTreeItem);
            arrayList.add(object);
            arrayList.add(invTweaksItemTreeItem);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            object.remove();
        }
        return arrayList;
    }

    public List getItems(String string) {
        return (List)this.itemsByName.get(string);
    }

    public InvTweaksItemTreeItem getRandomItem(Random random) {
        return (InvTweaksItemTreeItem)this.itemsByName.values().toArray()[random.nextInt(this.itemsByName.size())];
    }

    public boolean containsItem(String string) {
        return this.itemsByName.containsKey(string);
    }

    public boolean containsCategory(String string) {
        return this.categories.containsKey(string);
    }

    public void setRootCategory(InvTweaksItemTreeCategory invTweaksItemTreeCategory) {
        this.rootCategory = invTweaksItemTreeCategory.getName();
        this.categories.put(this.rootCategory, invTweaksItemTreeCategory);
    }

    public void addCategory(String string, InvTweaksItemTreeCategory invTweaksItemTreeCategory) throws NullPointerException {
        ((InvTweaksItemTreeCategory)this.categories.get(string.toLowerCase())).addCategory(invTweaksItemTreeCategory);
        this.categories.put(invTweaksItemTreeCategory.getName(), invTweaksItemTreeCategory);
    }

    public void addItem(String string, InvTweaksItemTreeItem invTweaksItemTreeItem) throws NullPointerException {
        Vector<InvTweaksItemTreeItem> vector;
        ((InvTweaksItemTreeCategory)this.categories.get(string.toLowerCase())).addItem(invTweaksItemTreeItem);
        if (this.itemsByName.containsKey(invTweaksItemTreeItem.getName())) {
            ((Vector)this.itemsByName.get(invTweaksItemTreeItem.getName())).add(invTweaksItemTreeItem);
        } else {
            vector = new Vector<InvTweaksItemTreeItem>();
            vector.add(invTweaksItemTreeItem);
            this.itemsByName.put(invTweaksItemTreeItem.getName(), vector);
        }
        if (this.itemsById.containsKey(invTweaksItemTreeItem.getId())) {
            ((Vector)this.itemsById.get(invTweaksItemTreeItem.getId())).add(invTweaksItemTreeItem);
        } else {
            vector = new Vector();
            vector.add(invTweaksItemTreeItem);
            this.itemsById.put(invTweaksItemTreeItem.getId(), vector);
        }
    }

    private void log(InvTweaksItemTreeCategory invTweaksItemTreeCategory, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        log.info(string + invTweaksItemTreeCategory.getName());
        for (Object object : invTweaksItemTreeCategory.getSubCategories()) {
            this.log((InvTweaksItemTreeCategory)object, n + 1);
        }
        for (Object object : invTweaksItemTreeCategory.getItems()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                InvTweaksItemTreeItem invTweaksItemTreeItem = (InvTweaksItemTreeItem)iterator.next();
                log.info(string + "  " + invTweaksItemTreeItem + " " + invTweaksItemTreeItem.getId() + " " + invTweaksItemTreeItem.getDamage());
            }
        }
    }
}

