/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeLoader;
import invtweaks.forge.ForgeClientTick;
import invtweaks.forge.ForgeItemTreeListener;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;

@Mod(modid="inventorytweaks", dependencies="required-after:FML@[5.0.0,);required-after:Forge@[7.7.0,)")
public class InvTweaksMod
implements IPickupNotifier {
    private InvTweaks instance;
    private ForgeClientTick clientTick;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        InvTweaks.log = fMLPreInitializationEvent.getModLog();
    }

    @Mod.Init
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        if (fMLInitializationEvent.getSide() == Side.CLIENT) {
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            this.instance = new InvTweaks(minecraft);
            this.clientTick = new ForgeClientTick(this.instance);
            TickRegistry.registerTickHandler((ITickHandler)this.clientTick, (Side)Side.CLIENT);
            GameRegistry.registerPickupHandler((IPickupNotifier)this);
        }
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        if (!InvTweaks.getConfigManager().getConfig().getProperty("enableForgeTreeAdditions").equals("false")) {
            InvTweaksItemTreeLoader.addOnLoadListener(new ForgeItemTreeListener());
        }
    }

    public void notifyPickup(EntityItem entityItem, EntityPlayer entityPlayer) {
        this.instance.setItemPickupPending(true);
    }
}

