/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigManager;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksContainerManager;
import invtweaks.InvTweaksContainerSectionManager;
import invtweaks.InvTweaksGuiSettingsButton;
import invtweaks.InvTweaksGuiSortingButton;
import invtweaks.InvTweaksHandlerSorting;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksLocalization;
import invtweaks.InvTweaksObfuscation;
import invtweaks.InvTweaksShortcutMapping;
import invtweaks.InvTweaksShortcutType;
import invtweaks.api.ContainerSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class InvTweaks
extends InvTweaksObfuscation {
    public static Logger log = Logger.getLogger("InvTweaks");
    private static InvTweaks instance;
    private InvTweaksConfigManager cfgManager = null;
    private int chestAlgorithm = 0;
    private long chestAlgorithmClickTimestamp = 0L;
    private boolean chestAlgorithmButtonDown = false;
    private int storedStackId = 0;
    private int storedStackDamage = -1;
    private int storedFocusedSlot = -1;
    private ItemStack[] hotbarClone = new ItemStack[9];
    private boolean hadFocus = true;
    private boolean mouseWasDown = false;
    private boolean wasInGUI = false;
    private int tickNumber = 0;
    private int lastPollingTickNumber = -3;
    private long sortingKeyPressedDate = 0L;
    private boolean sortKeyDown = false;
    private boolean itemPickupPending = false;

    public InvTweaks(Minecraft minecraft) {
        super(minecraft);
        log.setLevel(InvTweaksConst.DEFAULT_LOG_LEVEL);
        instance = this;
        this.cfgManager = new InvTweaksConfigManager(minecraft);
        if (this.cfgManager.makeSureConfigurationIsLoaded()) {
            log.info("Mod initialized");
        } else {
            log.severe("Mod failed to initialize!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.onTick()) {
                return;
            }
            this.handleAutoRefill();
            if (this.wasInGUI) {
                this.wasInGUI = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGUI(GuiScreen guiScreen) {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            this.handleMiddleClick(guiScreen);
            if (!this.onTick()) {
                return;
            }
            if (this.isTimeForPolling()) {
                this.unlockKeysIfNecessary();
            }
            this.handleGUILayout(guiScreen);
            if (!this.wasInGUI) {
                this.mouseWasDown = true;
            }
            this.handleShortcuts(guiScreen);
            ItemStack itemStack = this.getFocusedStack();
            this.storedStackId = itemStack == null ? 0 : this.getItemID(itemStack);
            int n = this.storedStackDamage = itemStack == null ? 0 : this.getItemDamage(itemStack);
            if (!this.wasInGUI) {
                this.wasInGUI = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSortingKeyPressed() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            GuiScreen guiScreen = this.getCurrentScreen();
            if (guiScreen == null || this.isValidChest(guiScreen) || this.isValidInventory(guiScreen)) {
                this.handleSorting(guiScreen);
            }
        }
    }

    public void onItemPickup() {
        if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
            return;
        }
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (this.cfgManager.getConfig().getProperty("enableSortingOnPickup").equals("false")) {
            return;
        }
        try {
            Object object;
            InvTweaksContainerSectionManager invTweaksContainerSectionManager = new InvTweaksContainerSectionManager(this.mc, ContainerSection.INVENTORY);
            int n = -1;
            for (int i = 0; i < 9; ++i) {
                object = invTweaksContainerSectionManager.getItemStack(i + 27);
                if (object == null || this.getAnimationsToGo((ItemStack)object) != 5 || this.hotbarClone[i] != null) continue;
                n = i + 27;
            }
            if (n != -1) {
                this.itemPickupPending = false;
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                object = invTweaksConfig.getTree();
                ItemStack itemStack = invTweaksContainerSectionManager.getItemStack(n);
                List list = ((InvTweaksItemTree)object).getItems(this.getItemID(itemStack), this.getItemDamage(itemStack));
                for (Object object2 : invTweaksConfig.getRules()) {
                    if (!((InvTweaksItemTree)object).matches(list, ((InvTweaksConfigSortingRule)object2).getKeyword())) continue;
                    for (int n2 : ((InvTweaksConfigSortingRule)object2).getPreferredSlots()) {
                        linkedList.add(n2);
                    }
                }
                boolean bl = true;
                if (linkedList != null) {
                    Object object2;
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        int n3 = (Integer)object2.next();
                        try {
                            if (n3 == n) {
                                bl = false;
                                break;
                            }
                            if (invTweaksContainerSectionManager.getItemStack(n3) != null || !invTweaksContainerSectionManager.move(n, n3)) continue;
                            break;
                        }
                        catch (TimeoutException timeoutException) {
                            this.logInGameError("Failed to move picked up stack", timeoutException);
                        }
                    }
                }
                if (bl) {
                    for (int i = 0; !(i >= invTweaksContainerSectionManager.getSize() || invTweaksContainerSectionManager.getItemStack(i) == null && invTweaksContainerSectionManager.move(n, i)); ++i) {
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logInGameError("Failed to move picked up stack", exception);
        }
    }

    public void setItemPickupPending(boolean bl) {
        this.itemPickupPending = bl;
    }

    public void logInGame(String string) {
        this.logInGame(string, false);
    }

    public void logInGame(String string, boolean bl) {
        String string2 = this.buildlogString(Level.INFO, bl ? string : InvTweaksLocalization.get(string));
        this.addChatMessage(string2);
        log.info(string2);
    }

    public void logInGameError(String string, Exception exception) {
        exception.printStackTrace();
        String string2 = this.buildlogString(Level.SEVERE, InvTweaksLocalization.get(string), exception);
        this.addChatMessage(string2);
    }

    public static void logInGameStatic(String string) {
        InvTweaks.getInstance().logInGame(string);
    }

    public static void logInGameErrorStatic(String string, Exception exception) {
        InvTweaks.getInstance().logInGameError(string, exception);
    }

    public static InvTweaks getInstance() {
        return instance;
    }

    public static Minecraft getMinecraftInstance() {
        return InvTweaks.instance.mc;
    }

    public static InvTweaksConfigManager getConfigManager() {
        return InvTweaks.instance.cfgManager;
    }

    public static boolean classExists(String string) {
        try {
            return Class.forName(string) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean onTick() {
        GuiScreen guiScreen;
        ++this.tickNumber;
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (invTweaksConfig == null) {
            return false;
        }
        if (this.itemPickupPending) {
            this.onItemPickup();
        }
        if ((guiScreen = this.getCurrentScreen()) == null || this.isGuiInventory(guiScreen)) {
            this.cloneHotbar();
        }
        if (Keyboard.isKeyDown((int)invTweaksConfig.getSortKeyCode())) {
            if (!this.sortKeyDown) {
                this.sortKeyDown = true;
                this.onSortingKeyPressed();
            }
        } else {
            this.sortKeyDown = false;
        }
        this.handleConfigSwitch();
        return true;
    }

    private void handleConfigSwitch() {
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        GuiScreen guiScreen = this.getCurrentScreen();
        this.cfgManager.getShortcutsHandler().updatePressedKeys();
        InvTweaksShortcutMapping invTweaksShortcutMapping = this.cfgManager.getShortcutsHandler().isShortcutDown(InvTweaksShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT);
        if (this.isSortingShortcutDown() && invTweaksShortcutMapping != null) {
            String string = null;
            int n = (Integer)invTweaksShortcutMapping.getKeyCodes().get(0);
            if (n >= 2 && n <= 10) {
                string = invTweaksConfig.switchConfig(n - 2);
            } else {
                switch (n) {
                    case 79: {
                        string = invTweaksConfig.switchConfig(0);
                        break;
                    }
                    case 80: {
                        string = invTweaksConfig.switchConfig(1);
                        break;
                    }
                    case 81: {
                        string = invTweaksConfig.switchConfig(2);
                        break;
                    }
                    case 75: {
                        string = invTweaksConfig.switchConfig(3);
                        break;
                    }
                    case 76: {
                        string = invTweaksConfig.switchConfig(4);
                        break;
                    }
                    case 77: {
                        string = invTweaksConfig.switchConfig(5);
                        break;
                    }
                    case 71: {
                        string = invTweaksConfig.switchConfig(6);
                        break;
                    }
                    case 72: {
                        string = invTweaksConfig.switchConfig(7);
                        break;
                    }
                    case 73: {
                        string = invTweaksConfig.switchConfig(8);
                    }
                }
            }
            if (string != null) {
                this.logInGame(String.format(InvTweaksLocalization.get("invtweaks.loadconfig.enabled"), string), true);
                this.sortingKeyPressedDate = Integer.MAX_VALUE;
            }
        }
        if (this.isSortingShortcutDown()) {
            long l = System.currentTimeMillis();
            if (this.sortingKeyPressedDate == 0L) {
                this.sortingKeyPressedDate = l;
            } else if (l - this.sortingKeyPressedDate > 1000L && this.sortingKeyPressedDate != Integer.MAX_VALUE) {
                String string = invTweaksConfig.getCurrentRulesetName();
                String string2 = invTweaksConfig.switchConfig();
                if (string != null && string2 != null && !string.equals(string2)) {
                    this.logInGame(String.format(InvTweaksLocalization.get("invtweaks.loadconfig.enabled"), string2), true);
                    this.handleSorting(guiScreen);
                }
                this.sortingKeyPressedDate = l;
            }
        } else {
            this.sortingKeyPressedDate = 0L;
        }
    }

    private void handleSorting(GuiScreen guiScreen) {
        ItemStack[] itemStackArray;
        ItemStack itemStack = null;
        int n = this.getFocusedSlot();
        if (n < (itemStackArray = this.getMainInventory()).length && n >= 0) {
            itemStack = itemStackArray[n];
        }
        try {
            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.INVENTORY, 3, 9).sort();
        }
        catch (Exception exception) {
            this.logInGameError("invtweaks.sort.inventory.error", exception);
            exception.printStackTrace();
        }
        this.playClick();
        if (itemStack != null && itemStackArray[n] == null) {
            this.storedStackId = 0;
        }
    }

    private void handleAutoRefill() {
        ItemStack itemStack = this.getFocusedStack();
        int n = itemStack == null ? 0 : this.getItemID(itemStack);
        int n2 = itemStack == null ? 0 : this.getItemDamage(itemStack);
        int n3 = this.getFocusedSlot() + 27;
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        if (n != this.storedStackId || n2 != this.storedStackDamage) {
            if (this.storedFocusedSlot != n3) {
                this.storedFocusedSlot = n3;
            } else if ((itemStack == null || this.getItemID(itemStack) == 281 && this.storedStackId == 282) && (this.getCurrentScreen() == null || this.isGuiEditSign(this.getCurrentScreen()))) {
                if (invTweaksConfig.isAutoRefillEnabled(this.storedStackId, this.storedStackId)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(n3, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception exception) {
                        this.logInGameError("invtweaks.sort.autorefill.error", exception);
                    }
                }
            } else {
                int n4 = this.getMaxDamage(this.getItem(itemStack));
                if (n4 != 0 && n4 - n2 < 5 && n4 - this.storedStackDamage >= 5 && invTweaksConfig.getProperty("autoRefillBeforeBreak").equals("true") && invTweaksConfig.isAutoRefillEnabled(this.storedStackId, this.storedStackId)) {
                    try {
                        this.cfgManager.getAutoRefillHandler().autoRefillSlot(n3, this.storedStackId, this.storedStackDamage);
                    }
                    catch (Exception exception) {
                        this.logInGameError("invtweaks.sort.autorefill.error", exception);
                    }
                }
            }
        }
        this.storedStackId = n;
        this.storedStackDamage = n2;
    }

    private void handleMiddleClick(GuiScreen guiScreen) {
        if (Mouse.isButtonDown((int)2)) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
            if (invTweaksConfig.getProperty("enableMiddleClick").equals("true") && !this.chestAlgorithmButtonDown) {
                this.chestAlgorithmButtonDown = true;
                InvTweaksContainerManager invTweaksContainerManager = new InvTweaksContainerManager(this.mc);
                Slot slot = invTweaksContainerManager.getSlotAtMousePosition();
                ContainerSection containerSection = null;
                if (slot != null) {
                    containerSection = invTweaksContainerManager.getSlotSection(this.getSlotNumber(slot));
                }
                if (this.isValidChest(guiScreen)) {
                    GuiContainer guiContainer = this.asGuiContainer(guiScreen);
                    if (ContainerSection.CHEST.equals((Object)containerSection)) {
                        this.playClick();
                        long l = System.currentTimeMillis();
                        if (l - this.chestAlgorithmClickTimestamp > 2000L) {
                            this.chestAlgorithm = 0;
                        }
                        try {
                            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), ContainerSection.CHEST, this.chestAlgorithm, this.getContainerRowSize(guiContainer)).sort();
                        }
                        catch (Exception exception) {
                            this.logInGameError("invtweaks.sort.chest.error", exception);
                            exception.printStackTrace();
                        }
                        this.chestAlgorithm = (this.chestAlgorithm + 1) % 3;
                        this.chestAlgorithmClickTimestamp = l;
                    } else if (ContainerSection.CRAFTING_IN.equals((Object)containerSection) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)containerSection)) {
                        try {
                            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), containerSection, 4, invTweaksContainerManager.getSize(containerSection) == 9 ? 3 : 2).sort();
                        }
                        catch (Exception exception) {
                            this.logInGameError("invtweaks.sort.crafting.error", exception);
                            exception.printStackTrace();
                        }
                    } else if (ContainerSection.INVENTORY_HOTBAR.equals((Object)containerSection) || ContainerSection.INVENTORY_NOT_HOTBAR.equals((Object)containerSection)) {
                        this.handleSorting(guiScreen);
                    }
                } else if (this.isValidInventory(guiScreen)) {
                    if (ContainerSection.CRAFTING_IN.equals((Object)containerSection) || ContainerSection.CRAFTING_IN_PERSISTENT.equals((Object)containerSection)) {
                        try {
                            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), containerSection, 4, invTweaksContainerManager.getSize(containerSection) == 9 ? 3 : 2).sort();
                        }
                        catch (Exception exception) {
                            this.logInGameError("invtweaks.sort.crafting.error", exception);
                            exception.printStackTrace();
                        }
                    } else {
                        this.handleSorting(guiScreen);
                    }
                }
            }
        } else {
            this.chestAlgorithmButtonDown = false;
        }
    }

    private void handleGUILayout(GuiScreen guiScreen) {
        InvTweaksConfig invTweaksConfig = this.cfgManager.getConfig();
        boolean bl = this.isValidChest(guiScreen);
        if (bl || this.isStandardInventory(guiScreen) && !this.isGuiEnchantmentTable(guiScreen)) {
            GuiContainer guiContainer = this.asGuiContainer(guiScreen);
            int n = 10;
            int n2 = 10;
            boolean bl2 = false;
            List list = this.getControlList(guiScreen);
            for (Object e : list) {
                GuiButton guiButton;
                if (!this.isGuiButton(e) || this.getId(guiButton = this.asGuiButton(e)) != 54696386) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                boolean bl3 = this.hasTexture("/gui/button10px.png");
                if (!bl) {
                    list.add(new InvTweaksGuiSettingsButton(this.cfgManager, 54696386, this.getGuiX(guiContainer) + this.getGuiWidth(guiContainer) - 15, this.getGuiY(guiContainer) + 5, n, n2, "...", InvTweaksLocalization.get("invtweaks.button.settings.tooltip"), bl3));
                } else {
                    this.chestAlgorithmClickTimestamp = 0L;
                    int n3 = 54696386;
                    int n4 = this.getGuiX(guiContainer) + this.getGuiWidth(guiContainer) - 16;
                    int n5 = this.getGuiY(guiContainer) + 5;
                    boolean bl4 = this.mods.isChestWayTooBig(guiScreen);
                    if (bl4 && InvTweaks.classExists("mod_NotEnoughItems") && this.isNotEnoughItemsEnabled()) {
                        n4 = this.getGuiX(guiContainer) + this.getGuiWidth(guiContainer) - 35;
                        n5 += 50;
                    }
                    list.add(new InvTweaksGuiSettingsButton(this.cfgManager, n3++, bl4 ? n4 + 22 : n4 - 1, bl4 ? n5 - 3 : n5, n, n2, "...", InvTweaksLocalization.get("invtweaks.button.settings.tooltip"), bl3));
                    if (!invTweaksConfig.getProperty("showChestButtons").equals("false")) {
                        int n6 = this.getContainerRowSize(guiContainer);
                        InvTweaksGuiSortingButton invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl4 ? n4 + 22 : n4 - 13, bl4 ? n5 + 12 : n5, n, n2, "h", InvTweaksLocalization.get("invtweaks.button.chest3.tooltip"), 2, n6, bl3);
                        list.add(invTweaksGuiSortingButton);
                        invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl4 ? n4 + 22 : n4 - 25, bl4 ? n5 + 25 : n5, n, n2, "v", InvTweaksLocalization.get("invtweaks.button.chest2.tooltip"), 1, n6, bl3);
                        list.add(invTweaksGuiSortingButton);
                        invTweaksGuiSortingButton = new InvTweaksGuiSortingButton(this.cfgManager, n3++, bl4 ? n4 + 22 : n4 - 37, bl4 ? n5 + 38 : n5, n, n2, "s", InvTweaksLocalization.get("invtweaks.button.chest1.tooltip"), 0, n6, bl3);
                        list.add(invTweaksGuiSortingButton);
                    }
                }
            }
        } else if (this.isGuiInventoryCreative(guiScreen)) {
            List list = this.getControlList(guiScreen);
            GuiButton guiButton = null;
            for (Object e : list) {
                if (!this.isGuiButton(e) || this.getId(this.asGuiButton(e)) != 54696386) continue;
                guiButton = this.asGuiButton(e);
                break;
            }
            if (guiButton != null) {
                list.remove(guiButton);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotEnoughItemsEnabled() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(new File(InvTweaksConst.MINECRAFT_CONFIG_DIR + "NEI.cfg")));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("enable=true")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void handleShortcuts(GuiScreen guiScreen) {
        if (!this.isValidChest(guiScreen) && !this.isStandardInventory(guiScreen)) {
            return;
        }
        if (this.isGuiInventoryCreative(guiScreen)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            if (!this.mouseWasDown) {
                this.mouseWasDown = true;
                if (this.cfgManager.getConfig().getProperty("enableShortcuts").equals("true")) {
                    this.cfgManager.getShortcutsHandler().handleShortcut();
                }
            }
        } else {
            this.mouseWasDown = false;
        }
    }

    private int getContainerRowSize(GuiContainer guiContainer) {
        if (this.isGuiChest(guiContainer)) {
            return 9;
        }
        if (this.isGuiDispenser(guiContainer)) {
            return 3;
        }
        return this.getSpecialChestRowSize(guiContainer, 9);
    }

    private boolean isSortingShortcutDown() {
        int n = this.cfgManager.getConfig().getSortKeyCode();
        if (n > 0) {
            return Keyboard.isKeyDown((int)n);
        }
        return Mouse.isButtonDown((int)(100 + n));
    }

    private boolean isTimeForPolling() {
        if (this.tickNumber - this.lastPollingTickNumber >= 3) {
            this.lastPollingTickNumber = this.tickNumber;
        }
        return this.tickNumber - this.lastPollingTickNumber == 0;
    }

    private void unlockKeysIfNecessary() {
        boolean bl = Display.isActive();
        if (!this.hadFocus && bl) {
            Keyboard.destroy();
            boolean bl2 = true;
            while (!Keyboard.isCreated()) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException lWJGLException) {
                    if (!bl2) continue;
                    this.logInGameError("invtweaks.keyboardfix.error", (Exception)((Object)lWJGLException));
                    bl2 = false;
                }
            }
            if (!bl2) {
                this.logInGame("invtweaks.keyboardfix.recover");
            }
        }
        this.hadFocus = bl;
    }

    private void cloneHotbar() {
        ItemStack[] itemStackArray = this.getMainInventory();
        for (int i = 0; i < 9; ++i) {
            this.hotbarClone[i] = itemStackArray[i] != null ? this.copy(itemStackArray[i]) : null;
        }
    }

    private void playClick() {
        if (!this.cfgManager.getConfig().getProperty("enableSounds").equals("false")) {
            this.playSound("random.click", 0.6f, 1.8f);
        }
    }

    private String buildlogString(Level level, String string, Exception exception) {
        if (exception != null) {
            StackTraceElement stackTraceElement = exception.getStackTrace()[0];
            if (stackTraceElement != null && stackTraceElement.getFileName() != null) {
                return this.buildlogString(level, string) + ": " + exception.getMessage() + " (l" + stackTraceElement.getLineNumber() + " in " + stackTraceElement.getFileName().replace("InvTweaks", "") + ")";
            }
            return this.buildlogString(level, string) + ": " + exception.getMessage();
        }
        return this.buildlogString(level, string);
    }

    private String buildlogString(Level level, String string) {
        return "InvTweaks: " + (level.equals(Level.SEVERE) ? "[ERROR] " : "") + string;
    }
}

