package uk.co.toomuchminecraft.sabermod;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;


public class BlockOre extends Block
{	
	public BlockOre(int i, int j)
    {
        super(i, j, Material.rock);
        setHardness(3F);
        setResistance(5F);
        setStepSound(Block.soundStoneFootstep);
        setCreativeTab(CreativeTabs.tabBlock);
    }
	
	@Override
	public String getTextureFile()
	{
		return "/SaberMod/terrain.png";
	}
	
	public int idDropped(int i, Random random, int j)
    {
        if (blockID == SaberMod.oreAmber.blockID)
        {
            return SaberMod.gemAmber.itemID;
        }
        if (blockID == SaberMod.oreAmethyst.blockID)
        {
            return SaberMod.gemAmethyst.itemID;
        }
        if (blockID == SaberMod.oreIolite.blockID)
        {
            return SaberMod.gemIolite.itemID;
        }
        if (blockID == SaberMod.oreJade.blockID)
        {
            return SaberMod.gemJade.itemID;
        }
        if (blockID == SaberMod.oreOnyx.blockID)
        {
            return SaberMod.gemOnyx.itemID;
        }
        if (blockID == SaberMod.oreRuby.blockID)
        {
            return SaberMod.gemRuby.itemID;
        }
        if (blockID == SaberMod.oreSapphire.blockID)
        {
            return SaberMod.gemSapphire.itemID;
        }
        if (blockID == SaberMod.oreTopaz.blockID)
        {
            return SaberMod.gemTopaz.itemID;
        }
        if (blockID == SaberMod.orePower.blockID)
        {
            return SaberMod.gemPower.itemID;
        }
        else
        {
            return blockID;
        }
    }
}
