/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeDirection;
import org.bouncycastle.util.Arrays;
import universalelectricity.core.electricity.Electricity;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityConductor
extends TileEntityAdvanced
implements IConductor,
IPacketReceiver {
    private ElectricityNetwork network;
    public boolean[] visuallyConnected = new boolean[]{false, false, false, false, false, false};
    public any[] connectedBlocks = new any[]{null, null, null, null, null, null};
    protected String channel = "";

    public TileEntityConductor() {
        ElectricityConnections.registerConnector(this, EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST));
        this.reset();
    }

    @Override
    public ElectricityNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(ElectricityNetwork network) {
        this.network = network;
    }

    @Override
    public any[] getConnectedBlocks() {
        return this.connectedBlocks;
    }

    @Override
    public void updateConnection(any tileEntity, ForgeDirection side) {
        if (!this.k.I) {
            if (tileEntity != null && ElectricityConnections.canConnect(tileEntity, side.getOpposite())) {
                this.connectedBlocks[side.ordinal()] = tileEntity;
                this.visuallyConnected[side.ordinal()] = true;
                if (tileEntity.getClass() == this.getClass()) {
                    Electricity.instance.mergeConnection(this.getNetwork(), ((IConductor)tileEntity).getNetwork());
                }
                return;
            }
            if (this.connectedBlocks[side.ordinal()] != null) {
                if (this.connectedBlocks[side.ordinal()] instanceof IConductor) {
                    Electricity.instance.splitConnection(this, (IConductor)this.getConnectedBlocks()[side.ordinal()]);
                }
                this.getNetwork().stopProducing(this.connectedBlocks[side.ordinal()]);
                this.getNetwork().stopRequesting(this.connectedBlocks[side.ordinal()]);
            }
            this.connectedBlocks[side.ordinal()] = null;
            this.visuallyConnected[side.ordinal()] = false;
        }
    }

    @Override
    public void updateConnectionWithoutSplit(any tileEntity, ForgeDirection side) {
        if (!this.k.I) {
            if (tileEntity != null && ElectricityConnections.canConnect(tileEntity, side.getOpposite())) {
                this.connectedBlocks[side.ordinal()] = tileEntity;
                this.visuallyConnected[side.ordinal()] = true;
                if (tileEntity.getClass() == this.getClass()) {
                    Electricity.instance.mergeConnection(this.getNetwork(), ((IConductor)tileEntity).getNetwork());
                }
                return;
            }
            this.connectedBlocks[side.ordinal()] = null;
            this.visuallyConnected[side.ordinal()] = false;
        }
    }

    @Override
    public void handlePacketData(ce network, int type, di packet, qx player, ByteArrayDataInput dataStream) {
        if (this.k.I) {
            this.visuallyConnected[0] = dataStream.readBoolean();
            this.visuallyConnected[1] = dataStream.readBoolean();
            this.visuallyConnected[2] = dataStream.readBoolean();
            this.visuallyConnected[3] = dataStream.readBoolean();
            this.visuallyConnected[4] = dataStream.readBoolean();
            this.visuallyConnected[5] = dataStream.readBoolean();
        }
    }

    @Override
    public void initiate() {
        this.refreshConnectedBlocks();
    }

    @Override
    public void g() {
        super.g();
        if (this.ticks % 300L == 0L) {
            this.refreshConnectedBlocks();
        }
    }

    @Override
    public void reset() {
        this.network = null;
        if (Electricity.instance != null) {
            Electricity.instance.registerConductor(this);
        }
    }

    @Override
    public void refreshConnectedBlocks() {
        if (this.k != null && !this.k.I) {
            boolean[] previousConnections = (boolean[])this.visuallyConnected.clone();
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.updateConnection(Vector3.getConnectorFromSide(this.k, new Vector3(this), ForgeDirection.getOrientation((int)i)), ForgeDirection.getOrientation((int)i));
            }
            if (!Arrays.areEqual((boolean[])previousConnections, (boolean[])this.visuallyConnected)) {
                this.k.i(this.l, this.m, this.n);
            }
        }
    }

    public ef l() {
        return PacketManager.getPacket(this.channel, this, new Object[]{this.visuallyConnected[0], this.visuallyConnected[1], this.visuallyConnected[2], this.visuallyConnected[3], this.visuallyConnected[4], this.visuallyConnected[5]});
    }

    @SideOnly(value=Side.CLIENT)
    public aoe getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

