/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLLog;
import icbm.sentry.api.ITurret;
import icbm.sentry.logic.actions.ActionManager;
import icbm.sentry.logic.actions.LookHelper;
import icbm.sentry.platform.TileEntityTurretPlatform;
import icbm.sentry.render.ITagRender;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityBaseTurret
extends TileEntityAdvanced
implements IPacketReceiver,
ITagRender,
IVoltage,
ITurret {
    public static final float MAX_PITCH = 30.0f;
    private ForgeDirection platformDirection = ForgeDirection.DOWN;
    public final ActionManager actionManager = new ActionManager();
    public LookHelper lookHelper = new LookHelper(this);
    public float targetRotationYaw;
    public float targetRotationPitch = 0.0f;
    public float rotationYaw;
    public float rotationPitch = 0.0f;
    public final float rotationSpeed = 4.0f;
    private int health = 100;

    @Override
    public void g() {
        super.g();
        if (this.isRunning()) {
            this.onUpdate();
        }
        if (this.health <= 0) {
            this.destroy(true);
        }
        if (!this.k.I && this.ticks % 10L == 0L) {
            PacketManager.sendPacketToClients(this.l(), this.k, new Vector3(this), 50.0);
        }
    }

    protected void onUpdate() {
        this.updateRotation();
    }

    @Override
    public TileEntityTurretPlatform getPlatform() {
        any tileEntity = this.k.q(this.l + this.platformDirection.offsetX, this.m + this.platformDirection.offsetY, this.n + this.platformDirection.offsetZ);
        if (tileEntity instanceof TileEntityTurretPlatform) {
            return (TileEntityTurretPlatform)tileEntity;
        }
        return null;
    }

    public void updateRotation() {
        if (Math.abs(this.rotationYaw - this.targetRotationYaw) > 0.001f) {
            float speedYaw = this.rotationYaw > this.targetRotationYaw ? -this.rotationSpeed : this.rotationSpeed;
            this.rotationYaw += speedYaw;
            if (Math.abs(this.rotationYaw - this.targetRotationYaw) < this.rotationSpeed + 0.1f) {
                this.rotationYaw = this.targetRotationYaw;
            }
        }
        if (Math.abs(this.rotationPitch - this.targetRotationPitch) > 0.001f) {
            float speedPitch = this.rotationPitch > this.targetRotationPitch ? -this.rotationSpeed : this.rotationSpeed;
            this.rotationPitch += speedPitch;
            if (Math.abs(this.rotationPitch - this.targetRotationPitch) < this.rotationSpeed + 0.1f) {
                this.rotationPitch = this.targetRotationPitch;
            }
        }
        this.rotationPitch = ke.g((float)Math.max(Math.min(this.rotationPitch, 60.0f), -60.0f));
        this.targetRotationYaw = ke.g((float)this.targetRotationYaw);
        this.targetRotationPitch = ke.g((float)Math.max(Math.min(this.targetRotationPitch, 60.0f), -60.0f));
    }

    public boolean isRunning() {
        return this.getPlatform() != null && this.getPlatform().isRunning();
    }

    public ef l() {
        bq nbt = new bq();
        this.b(nbt);
        return PacketManager.getPacket("ICBM", this, new Object[]{nbt});
    }

    @Override
    public void handlePacketData(ce network, int packetType, di packet, qx player, ByteArrayDataInput dataStream) {
        if (this.k.I) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(packet.c);
                DataInputStream dis = new DataInputStream(bis);
                int id = dis.readInt();
                int x = dis.readInt();
                int y2 = dis.readInt();
                int z2 = dis.readInt();
                bq tag = ef.d((DataInputStream)dis);
                this.a(tag);
            }
            catch (IOException e) {
                FMLLog.severe((String)"Failed to receive packet for Sentry", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public void b(bq nbt) {
        super.b(nbt);
        nbt.a("yaw", this.targetRotationYaw);
        nbt.a("pitch", this.targetRotationPitch);
        nbt.a("hp", this.health);
        nbt.a("dir", this.platformDirection.ordinal());
    }

    public void a(bq nbt) {
        super.a(nbt);
        this.targetRotationYaw = nbt.g("yaw");
        this.targetRotationPitch = nbt.g("pitch");
        this.health = nbt.e("hp");
        this.platformDirection = ForgeDirection.getOrientation((int)nbt.e("dir"));
    }

    public boolean destroy(boolean doExplosion) {
        if (doExplosion) {
            this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 2.0f, true);
        }
        this.q().c(this.k, this.l, this.m, this.n, this.p(), 0);
        return this.k.e(this.l, this.m, this.n, 0);
    }

    public void setDeploySide(ForgeDirection side) {
        this.platformDirection = side.getOpposite();
    }

    @Override
    public float addInformation(HashMap map, qx player) {
        map.put(this.getName(), 0x88FF88);
        return 1.0f;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.targetRotationYaw = yaw;
        this.targetRotationPitch = pitch;
    }

    @Override
    public Vector3 getMuzzle() {
        Vector3 position = new Vector3((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5);
        return Vector3.add(position, Vector3.multiply(LookHelper.getDeltaPositionFromRotation(this.targetRotationYaw, this.targetRotationPitch - 10.0f), 0.5));
    }
}

