/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.terminal.command;

import icbm.sentry.api.ISpecialAccess;
import icbm.sentry.api.ITerminal;
import icbm.sentry.platform.TileEntityTurretPlatform;
import icbm.sentry.terminal.AccessLevel;
import icbm.sentry.terminal.TerminalCommand;
import icbm.sentry.terminal.UserAccess;
import java.util.ArrayList;
import java.util.List;

public class CommandUser
extends TerminalCommand {
    @Override
    public String getCommandPrefix() {
        return "users";
    }

    @Override
    public boolean processCommand(qx player, ITerminal terminal, String[] args) {
        if (args[0].equalsIgnoreCase("users") && args.length > 1 && args[1] != null && terminal instanceof TileEntityTurretPlatform) {
            TileEntityTurretPlatform turret = (TileEntityTurretPlatform)terminal;
            if (args[1].equalsIgnoreCase("List")) {
                terminal.addToConsole("");
                terminal.addToConsole("Listing Users");
                for (int i = 0; i < turret.getUsers().size(); ++i) {
                    terminal.addToConsole(" " + i + ") " + ((UserAccess)turret.getUsers().get((int)i)).username);
                }
                return true;
            }
            if (args[1].equalsIgnoreCase("remove") && args.length > 2) {
                if (args[2] != null) {
                    if (turret.removeUserAccess(args[2])) {
                        terminal.addToConsole("Removed: " + args[2]);
                        return true;
                    }
                    terminal.addToConsole(" User not found.");
                    return true;
                }
                terminal.addToConsole("Invalid username.");
                return true;
            }
            if (args[1].equalsIgnoreCase("add") && args.length > 2) {
                if (args[2] != null) {
                    if (turret.addUserAccess(args[2], AccessLevel.USER, true)) {
                        terminal.addToConsole("Added: " + args[2]);
                        return true;
                    }
                    terminal.addToConsole("User already exists.");
                    return true;
                }
                terminal.addToConsole("Invalid username.");
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean canPlayerUse(qx var1, ISpecialAccess mm) {
        return mm.getUserAccess(var1.bR).ordinal() >= AccessLevel.ADMIN.ordinal();
    }

    @Override
    public boolean showOnHelp(qx player, ISpecialAccess mm) {
        return this.canPlayerUse(player, mm);
    }

    @Override
    public List getCmdUses(qx player, ISpecialAccess mm) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("users list");
        cmds.add("users add [player]");
        cmds.add("users remove [player]");
        return cmds;
    }

    @Override
    public boolean canMachineUse(ISpecialAccess mm) {
        return mm instanceof TileEntityTurretPlatform;
    }
}

