/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.logic.actions;

import icbm.sentry.turret.TileEntityBaseTurret;
import universalelectricity.core.vector.Vector3;

public class LookHelper {
    public static final int PITCH_DISPLACEMENT = 0;
    TileEntityBaseTurret sentry;

    public LookHelper(TileEntityBaseTurret turret) {
        this.sentry = turret;
    }

    public void lookAt(Vector3 target) {
        this.sentry.targetRotationYaw = LookHelper.getYaw(this.sentry.getMuzzle(), target);
        this.sentry.targetRotationPitch = LookHelper.getPitch(this.sentry.getMuzzle(), target);
    }

    public void lookAtEntity(lq entity) {
        this.lookAt(Vector3.add(new Vector3(entity), new Vector3(0.0, entity.e(), 0.0)));
    }

    public boolean isLookingAt(Vector3 target, float allowedError) {
        float pitch = LookHelper.getPitch(this.sentry.getMuzzle(), target);
        float yaw = LookHelper.getYaw(this.sentry.getMuzzle(), target);
        return LookHelper.getAngleDif(this.sentry.rotationYaw, yaw) <= allowedError && LookHelper.getAngleDif(this.sentry.rotationPitch, pitch) <= allowedError;
    }

    public boolean isLookingAt(lq entity, float allowedError) {
        return this.isLookingAt(new Vector3(entity.t, entity.u + (double)entity.e(), entity.v), allowedError);
    }

    public static float getPitch(Vector3 position, Vector3 target) {
        Vector3 difference = Vector3.subtract(target, position);
        double verticleDistance = ke.a((double)(difference.x * difference.x + difference.z * difference.z));
        return -ke.g((float)((float)(Math.atan2(difference.y, verticleDistance) * 180.0 / Math.PI) + 0.0f));
    }

    public static float getYaw(Vector3 position, Vector3 target) {
        Vector3 difference = Vector3.subtract(target, position);
        return ke.g((float)((float)(Math.atan2(difference.z, difference.x) * 180.0 / Math.PI) - 90.0f));
    }

    public static Vector3 getDeltaPositionFromRotation(float rotationYaw, float rotationPitch) {
        float z2 = ke.b((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float x = ke.a((float)(-rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -ke.b((float)(-rotationPitch * ((float)Math.PI / 180)));
        float y2 = ke.a((float)(-rotationPitch * ((float)Math.PI / 180)));
        return new Vector3(x * var4, y2, z2 * var4);
    }

    public static float getAngleDif(float angleOne, float angleTwo) {
        double dif = Math.max(angleOne, angleTwo) - Math.min(angleOne, angleTwo);
        return ke.g((float)((float)dif));
    }

    public boolean canEntityBeSeen(Vector3 target) {
        Vector3 barrel = Vector3.add(this.sentry.getMuzzle(), new Vector3(Math.sin(this.sentry.targetRotationYaw) * 1.0, 0.0, Math.cos(this.sentry.targetRotationYaw) * 1.0));
        return this.sentry.k.a(barrel.toVec3(), target.toVec3()) == null;
    }

    public boolean canEntityBeSeen(lq entity) {
        return this.canEntityBeSeen(Vector3.add(new Vector3(entity), new Vector3(0.0, entity.e(), 0.0)));
    }
}

