/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.logic.actions;

import icbm.sentry.logic.actions.Action;

public class ActionRotateBy
extends Action {
    float targetRotationYaw = 0.0f;
    float targetRotationPitch = 0.0f;
    float deltaPitch = 0.0f;
    float deltaYaw = 90.0f;
    float totalTicks = 0.0f;

    @Override
    public void onTaskStart() {
        super.onTaskStart();
        this.ticks = 0;
        if (this.getArg(0) != null) {
            this.targetRotationYaw = this.tileEntity.targetRotationYaw + this.getFloatArg(0).floatValue();
            this.deltaYaw = this.getFloatArg(0).floatValue();
        } else {
            this.targetRotationYaw = this.tileEntity.targetRotationYaw + 90.0f;
        }
        if (this.getArg(1) != null) {
            this.targetRotationPitch = this.tileEntity.targetRotationPitch + this.getFloatArg(1).floatValue();
            this.deltaPitch = this.getFloatArg(1).floatValue();
        } else {
            this.targetRotationPitch = this.tileEntity.targetRotationPitch;
        }
        while (this.targetRotationYaw < 0.0f) {
            this.targetRotationYaw += 360.0f;
        }
        while (this.targetRotationYaw > 360.0f) {
            this.targetRotationYaw -= 360.0f;
        }
        while (this.targetRotationPitch < 0.0f) {
            this.targetRotationPitch += 60.0f;
        }
        while (this.targetRotationPitch > 60.0f) {
            this.targetRotationPitch -= 60.0f;
        }
        float totalTicksYaw = Math.abs(this.targetRotationYaw - this.tileEntity.targetRotationYaw) / this.tileEntity.rotationSpeed;
        float totalTicksPitch = Math.abs(this.targetRotationPitch - this.tileEntity.targetRotationPitch) / this.tileEntity.rotationSpeed;
        this.totalTicks = Math.max(totalTicksYaw, totalTicksPitch);
    }

    @Override
    protected boolean onUpdateTask() {
        super.onUpdateTask();
        if (Math.abs(this.tileEntity.targetRotationYaw - this.targetRotationYaw) > 0.001f) {
            this.tileEntity.targetRotationYaw = this.targetRotationYaw;
        }
        if (Math.abs(this.tileEntity.targetRotationPitch - this.targetRotationPitch) > 0.001f) {
            this.tileEntity.targetRotationPitch = this.targetRotationPitch;
        }
        if (Math.abs(this.tileEntity.rotationYaw - this.tileEntity.targetRotationPitch) > 0.001f) {
            return true;
        }
        return Math.abs(this.tileEntity.rotationPitch - this.tileEntity.targetRotationYaw) > 0.001f;
    }

    @Override
    public void readFromNBT(bq taskCompound) {
        super.readFromNBT(taskCompound);
        this.targetRotationPitch = taskCompound.g("rotPitch");
        this.targetRotationYaw = taskCompound.g("rotYaw");
    }

    @Override
    public void writeToNBT(bq taskCompound) {
        super.writeToNBT(taskCompound);
        taskCompound.a("rotPitch", this.targetRotationPitch);
        taskCompound.a("rotYaw", this.targetRotationYaw);
    }

    public String toString() {
        return "ROTATE " + Float.toString(this.deltaYaw) + " " + Float.toString(this.deltaPitch);
    }
}

